/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public final class AdaptiveCalculator {
    private static final int[] SIZE_TABLE;
    private final int minIndex;
    private final int maxIndex;
    private final int minCapacity;
    private final int maxCapacity;
    private int index;
    private int nextSize;
    private boolean decreaseNow;

    private static int getSizeTableIndex(int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = SIZE_TABLE.length - 1;
        while (true) {
            if (n6 < n5) {
                return n5;
            }
            if (n6 == n5) {
                return n6;
            }
            n4 = n5 + n6 >>> 1;
            n3 = SIZE_TABLE[n4];
            int n7 = SIZE_TABLE[n4 + 1];
            if (n2 > n7) {
                n5 = n4 + 1;
                continue;
            }
            if (n2 >= n3) break;
            n6 = n4 - 1;
        }
        if (n2 == n3) {
            return n4;
        }
        return n4 + 1;
    }

    public AdaptiveCalculator(int n2, int n3, int n4) {
        ObjectUtil.checkPositive(n2, "minimum");
        if (n3 < n2) {
            throw new IllegalArgumentException("initial: " + n3);
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("maximum: " + n4);
        }
        int n5 = AdaptiveCalculator.getSizeTableIndex(n2);
        this.minIndex = SIZE_TABLE[n5] < n2 ? n5 + 1 : n5;
        int n6 = AdaptiveCalculator.getSizeTableIndex(n4);
        this.maxIndex = SIZE_TABLE[n6] > n4 ? n6 - 1 : n6;
        int n7 = AdaptiveCalculator.getSizeTableIndex(n3);
        this.index = SIZE_TABLE[n7] > n3 ? n7 - 1 : n7;
        this.minCapacity = n2;
        this.maxCapacity = n4;
        this.nextSize = Math.max(SIZE_TABLE[this.index], this.minCapacity);
    }

    public void record(int n2) {
        if (n2 <= SIZE_TABLE[Math.max(0, this.index - 1)]) {
            if (this.decreaseNow) {
                this.index = Math.max(this.index - 1, this.minIndex);
                this.nextSize = Math.max(SIZE_TABLE[this.index], this.minCapacity);
                this.decreaseNow = false;
            } else {
                this.decreaseNow = true;
            }
        } else if (n2 >= this.nextSize) {
            this.index = Math.min(this.index + 4, this.maxIndex);
            this.nextSize = Math.min(SIZE_TABLE[this.index], this.maxCapacity);
            this.decreaseNow = false;
        }
    }

    public int nextSize() {
        return this.nextSize;
    }

    static {
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 16; n2 < 512; n2 += 16) {
            arrayList.add(n2);
        }
        for (n2 = 512; n2 > 0; n2 <<= 1) {
            arrayList.add(n2);
        }
        SIZE_TABLE = new int[arrayList.size()];
        for (n2 = 0; n2 < SIZE_TABLE.length; ++n2) {
            AdaptiveCalculator.SIZE_TABLE[n2] = (Integer)arrayList.get(n2);
        }
    }
}

