/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocalRunnable;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.InternalThreadLocalMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.LongLongHashMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicReference;

public class FastThreadLocalThread
extends Thread {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FastThreadLocalThread.class);
    private static final AtomicReference<FallbackThreadSet> fallbackThreads = new AtomicReference<FallbackThreadSet>(FallbackThreadSet.EMPTY);
    private final boolean cleanupFastThreadLocals;
    private InternalThreadLocalMap threadLocalMap;

    public FastThreadLocalThread() {
        this.cleanupFastThreadLocals = false;
    }

    public FastThreadLocalThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, FastThreadLocalRunnable.wrap(runnable), string);
        this.cleanupFastThreadLocals = true;
    }

    public final InternalThreadLocalMap threadLocalMap() {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to get 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        return this.threadLocalMap;
    }

    public final void setThreadLocalMap(InternalThreadLocalMap internalThreadLocalMap) {
        if (this != Thread.currentThread() && logger.isWarnEnabled()) {
            logger.warn(new RuntimeException("It's not thread-safe to set 'threadLocalMap' which doesn't belong to the caller thread"));
        }
        this.threadLocalMap = internalThreadLocalMap;
    }

    @Deprecated
    public boolean willCleanupFastThreadLocals() {
        return this.cleanupFastThreadLocals;
    }

    public static boolean currentThreadWillCleanupFastThreadLocals() {
        Thread thread = FastThreadLocalThread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).willCleanupFastThreadLocals();
        }
        return FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    public static boolean currentThreadHasFastThreadLocal() {
        return FastThreadLocalThread.currentThread() instanceof FastThreadLocalThread || FastThreadLocalThread.isFastThreadLocalVirtualThread();
    }

    private static boolean isFastThreadLocalVirtualThread() {
        return fallbackThreads.get().contains(FastThreadLocalThread.currentThread().getId());
    }

    private static final class FallbackThreadSet {
        static final FallbackThreadSet EMPTY = new FallbackThreadSet();
        private final LongLongHashMap map = new LongLongHashMap(0L);

        private FallbackThreadSet() {
        }

        public boolean contains(long l2) {
            long l3 = l2 >>> 6;
            long l4 = 1L << (int)(l2 & 0x3FL);
            long l5 = this.map.get(l3);
            return (l5 & l4) != 0L;
        }
    }
}

