/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageToMessageEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.RandomWebSocketFrameMaskGenerator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameMaskGenerator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private final WebSocketFrameMaskGenerator maskGenerator;

    public WebSocket08FrameEncoder(boolean bl2) {
        this(bl2 ? RandomWebSocketFrameMaskGenerator.INSTANCE : null);
    }

    public WebSocket08FrameEncoder(WebSocketFrameMaskGenerator webSocketFrameMaskGenerator) {
        super(WebSocketFrame.class);
        this.maskGenerator = webSocketFrameMaskGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        ByteBuf byteBuf = webSocketFrame.content();
        byte by2 = WebSocket08FrameEncoder.getOpCode(webSocketFrame);
        int n2 = byteBuf.readableBytes();
        if (logger.isTraceEnabled()) {
            logger.trace("Encoding WebSocket Frame opCode={} length={}", by2, n2);
        }
        int n3 = 0;
        if (webSocketFrame.isFinalFragment()) {
            n3 |= 0x80;
        }
        n3 |= (webSocketFrame.rsv() & 7) << 4;
        n3 |= by2 & 0x7F;
        if (by2 == 9 && n2 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n2);
        }
        boolean bl2 = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n4;
            int n5;
            int n6 = n5 = this.maskGenerator != null ? 4 : 0;
            if (n2 <= 125) {
                n4 = 2 + n5 + n2;
                referenceCounted = channelHandlerContext.alloc().buffer(n4);
                ((ByteBuf)referenceCounted).writeByte(n3);
                byte by3 = (byte)(this.maskGenerator != null ? 0x80 | n2 : n2);
                ((ByteBuf)referenceCounted).writeByte(by3);
            } else if (n2 <= 65535) {
                n4 = 4 + n5;
                if (this.maskGenerator != null || n2 <= 1024) {
                    n4 += n2;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n4);
                ((ByteBuf)referenceCounted).writeByte(n3);
                ((ByteBuf)referenceCounted).writeByte(this.maskGenerator != null ? 254 : 126);
                ((ByteBuf)referenceCounted).writeByte(n2 >>> 8 & 0xFF);
                ((ByteBuf)referenceCounted).writeByte(n2 & 0xFF);
            } else {
                n4 = 10 + n5;
                if (this.maskGenerator != null) {
                    n4 += n2;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n4);
                ((ByteBuf)referenceCounted).writeByte(n3);
                ((ByteBuf)referenceCounted).writeByte(this.maskGenerator != null ? 255 : 127);
                ((ByteBuf)referenceCounted).writeLong(n2);
            }
            if (this.maskGenerator != null) {
                n4 = this.maskGenerator.nextMask();
                ((ByteBuf)referenceCounted).writeInt(n4);
                if (n4 != 0) {
                    if (n2 > 0) {
                        ByteOrder byteOrder = byteBuf.order();
                        ByteOrder byteOrder2 = ((ByteBuf)referenceCounted).order();
                        int n7 = byteBuf.readerIndex();
                        int n8 = byteBuf.writerIndex();
                        if (byteOrder == byteOrder2) {
                            long l2 = (long)n4 & 0xFFFFFFFFL;
                            l2 |= l2 << 32;
                            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                                l2 = Long.reverseBytes(l2);
                            }
                            int n9 = n8 - 7;
                            while (n7 < n9) {
                                ((ByteBuf)referenceCounted).writeLong(byteBuf.getLong(n7) ^ l2);
                                n7 += 8;
                            }
                            if (n7 < n8 - 3) {
                                ((ByteBuf)referenceCounted).writeInt(byteBuf.getInt(n7) ^ (int)l2);
                                n7 += 4;
                            }
                        }
                        int n10 = 0;
                        while (n7 < n8) {
                            byte by4 = byteBuf.getByte(n7);
                            ((ByteBuf)referenceCounted).writeByte(by4 ^ WebSocketUtil.byteAtIndex(n4, n10++ & 3));
                            ++n7;
                        }
                    }
                    list.add(referenceCounted);
                } else {
                    WebSocket08FrameEncoder.addBuffers((ByteBuf)referenceCounted, byteBuf, list);
                }
            } else {
                WebSocket08FrameEncoder.addBuffers((ByteBuf)referenceCounted, byteBuf, list);
            }
            bl2 = false;
        }
        finally {
            if (bl2 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    private static byte getOpCode(WebSocketFrame webSocketFrame) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            return 1;
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return 2;
        }
        if (webSocketFrame instanceof PingWebSocketFrame) {
            return 9;
        }
        if (webSocketFrame instanceof PongWebSocketFrame) {
            return 10;
        }
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            return 8;
        }
        if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            return 0;
        }
        throw new UnsupportedOperationException("Cannot encode frame of type: " + webSocketFrame.getClass().getName());
    }

    private static void addBuffers(ByteBuf byteBuf, ByteBuf byteBuf2, List<Object> list) {
        int n2 = byteBuf2.readableBytes();
        if (byteBuf.writableBytes() >= n2) {
            byteBuf.writeBytes(byteBuf2);
            list.add(byteBuf);
        } else {
            list.add(byteBuf);
            if (n2 > 0) {
                list.add(byteBuf2.retain());
            }
        }
    }
}

