/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.ZlibDecoder;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.ZlibUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.ZlibWrapper;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.jcraft.jzlib.Inflater;
import java.util.List;

public class JZlibDecoder
extends ZlibDecoder {
    private final Inflater z = new Inflater();
    private byte[] dictionary;
    private boolean needsRead;
    private volatile boolean finished;

    @Deprecated
    public JZlibDecoder() {
        this(ZlibWrapper.ZLIB, 0);
    }

    public JZlibDecoder(ZlibWrapper zlibWrapper, int n2) {
        super(n2);
        ObjectUtil.checkNotNull(zlibWrapper, "wrapper");
        int n3 = this.z.init(ZlibUtil.convertWrapperType(zlibWrapper));
        if (n3 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        this.needsRead = true;
        if (this.finished) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return;
        }
        try {
            this.z.avail_in = n2;
            if (byteBuf.hasArray()) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n2];
                byteBuf.getBytes(byteBuf.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            int n3 = this.z.next_in_index;
            ByteBuf byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, null, n2 << 1);
            block12: while (true) {
                block13: while (true) {
                    byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, byteBuf2, this.z.avail_in << 1);
                    this.z.avail_out = byteBuf2.writableBytes();
                    this.z.next_out = byteBuf2.array();
                    int n4 = this.z.next_out_index = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
                    int n5 = this.z.inflate(2);
                    int n6 = this.z.next_out_index - n4;
                    if (n6 > 0) {
                        byteBuf2.writerIndex(byteBuf2.writerIndex() + n6);
                        if (this.maxAllocation == 0) {
                            ByteBuf byteBuf3 = byteBuf2;
                            byteBuf2 = null;
                            this.needsRead = false;
                            channelHandlerContext.fireChannelRead(byteBuf3);
                        }
                    }
                    switch (n5) {
                        case 2: {
                            if (this.dictionary == null) {
                                ZlibUtil.fail(this.z, "decompression failure", n5);
                                continue block12;
                            }
                            n5 = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                            if (n5 == 0) continue block12;
                            ZlibUtil.fail(this.z, "failed to set the dictionary", n5);
                            continue block12;
                        }
                        case 1: {
                            this.finished = true;
                            this.z.inflateEnd();
                            return;
                        }
                        case 0: {
                            continue block12;
                        }
                        case -5: {
                            if (this.z.avail_in <= 0) return;
                            continue block12;
                        }
                        default: {
                            ZlibUtil.fail(this.z, "decompression failure", n5);
                            continue block13;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n3);
                if (byteBuf2 != null) {
                    if (byteBuf2.isReadable()) {
                        this.needsRead = false;
                        channelHandlerContext.fireChannelRead(byteBuf2);
                    } else {
                        byteBuf2.release();
                    }
                }
            }
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.discardSomeReadBytes();
        if (this.needsRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
        this.finished = true;
    }
}

