/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.CompressionUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(){

        @Override
        public boolean process(byte by2) throws Exception {
            ByteBufChecksum.this.update(by2);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull(checksum, "checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        return new JdkByteBufChecksum(checksum);
    }

    public void update(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.hasArray()) {
            this.update(byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
        } else {
            byteBuf.forEachByte(n2, n3, this.updateProcessor);
        }
    }

    private static class JdkByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;
        private byte[] scratchBuffer;

        JdkByteBufChecksum(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(int n2) {
            this.checksum.update(n2);
        }

        @Override
        public void update(ByteBuf byteBuf, int n2, int n3) {
            if (byteBuf.hasArray()) {
                this.update(byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
            } else if (this.checksum instanceof CRC32) {
                ByteBuffer byteBuffer = this.getSafeBuffer(byteBuf, n2, n3);
                ((CRC32)this.checksum).update(byteBuffer);
            } else if (this.checksum instanceof Adler32) {
                ByteBuffer byteBuffer = this.getSafeBuffer(byteBuf, n2, n3);
                ((Adler32)this.checksum).update(byteBuffer);
            } else {
                super.update(byteBuf, n2, n3);
            }
        }

        private ByteBuffer getSafeBuffer(ByteBuf byteBuf, int n2, int n3) {
            ByteBuffer byteBuffer = CompressionUtil.safeNioBuffer(byteBuf, n2, n3);
            int n4 = PlatformDependent.javaVersion();
            if (n4 >= 22 && n4 < 25 && byteBuffer.isDirect()) {
                if (this.scratchBuffer == null || this.scratchBuffer.length < n3) {
                    this.scratchBuffer = new byte[n3];
                }
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.scratchBuffer, 0, n3);
                byteBuffer2.put(byteBuffer).flip();
                return byteBuffer2;
            }
            return byteBuffer;
        }

        @Override
        public void update(byte[] byArray, int n2, int n3) {
            this.checksum.update(byArray, n2, n3);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }
}

