/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.IoEventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoEventLoopGroup;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoHandle;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoHandlerFactory;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoOps;
import com.gradle.maven.extension.internal.dep.io.netty.channel.IoRegistration;
import com.gradle.maven.extension.internal.dep.io.netty.channel.SingleThreadEventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SingleThreadIoEventLoop
extends SingleThreadEventLoop
implements IoEventLoop {
    private static final long DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS = TimeUnit.MILLISECONDS.toNanos(Math.max(100, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.eventLoop.maxTaskProcessingQuantumMs", 1000)));
    private final long maxTaskProcessingQuantumNs;
    private final IoHandlerContext context = new IoHandlerContext(){

        @Override
        public boolean canBlock() {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return !SingleThreadIoEventLoop.this.hasTasks() && !SingleThreadIoEventLoop.this.hasScheduledTasks();
        }

        @Override
        public long delayNanos(long l2) {
            assert (SingleThreadIoEventLoop.this.inEventLoop());
            return SingleThreadIoEventLoop.this.delayNanos(l2);
        }

        @Override
        public void reportActiveIoTime(long l2) {
            SingleThreadIoEventLoop.this.reportActiveIoTime(l2);
        }

        @Override
        public boolean shouldReportActiveIoTime() {
            return SingleThreadIoEventLoop.this.isSuspensionSupported();
        }
    };
    private final IoHandler ioHandler;
    private final AtomicInteger numRegistrations = new AtomicInteger();

    public SingleThreadIoEventLoop(IoEventLoopGroup ioEventLoopGroup, Executor executor, IoHandlerFactory ioHandlerFactory) {
        super(ioEventLoopGroup, executor, false, ObjectUtil.checkNotNull(ioHandlerFactory, "ioHandlerFactory").isChangingThreadSupported());
        this.maxTaskProcessingQuantumNs = DEFAULT_MAX_TASK_PROCESSING_QUANTUM_NS;
        this.ioHandler = ioHandlerFactory.newHandler(this);
    }

    @Override
    protected void run() {
        assert (this.inEventLoop());
        this.ioHandler.initialize();
        do {
            this.runIo();
            if (this.isShuttingDown()) {
                this.ioHandler.prepareToDestroy();
            }
            this.runAllTasks(this.maxTaskProcessingQuantumNs);
        } while (!this.confirmShutdown() && !this.canSuspend());
    }

    @Override
    protected boolean canSuspend(int n2) {
        return super.canSuspend(n2) && this.numRegistrations.get() == 0;
    }

    protected int runIo() {
        assert (this.inEventLoop());
        return this.ioHandler.run(this.context);
    }

    @Override
    public IoEventLoop next() {
        return this;
    }

    @Override
    public final Future<IoRegistration> register(IoHandle ioHandle) {
        Promise<IoRegistration> promise = this.newPromise();
        if (this.inEventLoop()) {
            this.registerForIo0(ioHandle, promise);
        } else {
            this.execute(() -> this.registerForIo0(ioHandle, promise));
        }
        return promise;
    }

    private void registerForIo0(IoHandle ioHandle, Promise<IoRegistration> promise) {
        IoRegistration ioRegistration;
        assert (this.inEventLoop());
        try {
            ioRegistration = this.ioHandler.register(ioHandle);
        }
        catch (Exception exception) {
            promise.setFailure(exception);
            return;
        }
        this.numRegistrations.incrementAndGet();
        promise.setSuccess(new IoRegistrationWrapper(ioRegistration));
    }

    @Override
    protected final void wakeup(boolean bl2) {
        this.ioHandler.wakeup();
    }

    @Override
    protected final void cleanup() {
        assert (this.inEventLoop());
        this.ioHandler.destroy();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> clazz) {
        return this.ioHandler.isCompatible(clazz);
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n2) {
        return SingleThreadIoEventLoop.newTaskQueue0(n2);
    }

    protected static Queue<Runnable> newTaskQueue0(int n2) {
        return n2 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n2);
    }

    private final class IoRegistrationWrapper
    implements IoRegistration {
        private final IoRegistration registration;

        IoRegistrationWrapper(IoRegistration ioRegistration) {
            this.registration = ioRegistration;
        }

        @Override
        public <T> T attachment() {
            return this.registration.attachment();
        }

        @Override
        public long submit(IoOps ioOps) {
            return this.registration.submit(ioOps);
        }

        @Override
        public boolean isValid() {
            return this.registration.isValid();
        }

        @Override
        public boolean cancel() {
            if (this.registration.cancel()) {
                SingleThreadIoEventLoop.this.numRegistrations.decrementAndGet();
                return true;
            }
            return false;
        }
    }
}

