/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelDuplexHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerMask;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FailedChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.Attribute;
import com.gradle.maven.extension.internal.dep.io.netty.util.AttributeKey;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakHint;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.OrderedEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PromiseNotificationUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor childExecutor;
    EventExecutor contextExecutor;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, Class<? extends ChannelHandler> clazz) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.childExecutor = eventExecutor;
        this.executionMask = ChannelHandlerMask.mask(clazz);
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        EventExecutor eventExecutor = this.contextExecutor;
        if (eventExecutor == null) {
            eventExecutor = this.childExecutor != null ? this.childExecutor : this.channel().eventLoop();
            this.contextExecutor = eventExecutor;
        }
        return eventExecutor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(2);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelRegistered(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).channelRegistered(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelRegistered(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelRegistered();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this::fireChannelRegistered);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(4);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelUnregistered(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).channelUnregistered(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelUnregistered(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelUnregistered();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this::fireChannelUnregistered);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(8);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelActive(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).channelActive(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelActive(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelActive();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this::fireChannelActive);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(16);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelInactive(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).channelInactive(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelInactive(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelInactive();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this::fireChannelInactive);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        block4: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(1);
            ObjectUtil.checkNotNull(throwable, "cause");
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            } else {
                try {
                    abstractChannelHandlerContext.executor().execute(() -> abstractChannelHandlerContext.invokeExceptionCaught(throwable));
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
                }
            }
        }
        return this;
    }

    private void invokeExceptionCaught(Throwable throwable) {
        if (this.invokeHandler()) {
            try {
                this.handler().exceptionCaught(this, throwable);
            }
            catch (Throwable throwable2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", throwable);
                } else if (logger.isWarnEnabled()) {
                    logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                }
            }
        } else {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        block8: {
            ObjectUtil.checkNotNull(object, "event");
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(128);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.userEventTriggered(abstractChannelHandlerContext, object);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).userEventTriggered(abstractChannelHandlerContext, object);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).userEventTriggered(abstractChannelHandlerContext, object);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireUserEventTriggered(object);
                }
            } else {
                abstractChannelHandlerContext.executor().execute(() -> this.fireUserEventTriggered(object));
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(32);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                Object object2 = this.pipeline.touch(object, abstractChannelHandlerContext);
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelRead(abstractChannelHandlerContext, object2);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)channelHandler).channelRead(abstractChannelHandlerContext, object2);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelRead(abstractChannelHandlerContext, object2);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelRead(object2);
                }
            } else {
                abstractChannelHandlerContext.executor().execute(() -> this.fireChannelRead(object));
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(64);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelReadComplete(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)channelHandler).channelReadComplete(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelReadComplete(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelReadComplete();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this.getInvokeTasks().invokeChannelReadCompleteTask);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        block8: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextInbound(256);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.channelWritabilityChanged(abstractChannelHandlerContext);
                            break block8;
                        }
                        if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)channelHandler).channelWritabilityChanged(abstractChannelHandlerContext);
                            break block8;
                        }
                        ((ChannelInboundHandler)channelHandler).channelWritabilityChanged(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.fireChannelWritabilityChanged();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this.getInvokeTasks().invokeChannelWritableStateChangedTask);
            }
        }
        return this;
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture bind(final SocketAddress socketAddress, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "localAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(512);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).bind(this, socketAddress, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.bind(socketAddress, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(1024);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.connect(socketAddress, socketAddress2, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise channelPromise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(channelPromise);
        }
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(2048);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDisconnect(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDisconnect(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).disconnect(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.disconnect(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture close(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(4096);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeClose(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).close(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.close(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture deregister(final ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        final AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(8192);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    abstractChannelHandlerContext.invokeDeregister(channelPromise);
                }
            }, channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (channelHandler == headContext) {
                        headContext.deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).deregister(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.deregister(channelPromise);
            }
        }
    }

    @Override
    public ChannelHandlerContext read() {
        block9: {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(16384);
            if (abstractChannelHandlerContext.executor().inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.read(abstractChannelHandlerContext);
                            break block9;
                        }
                        if (channelHandler instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)channelHandler).read(abstractChannelHandlerContext);
                            break block9;
                        }
                        if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                            ((ChannelOutboundHandlerAdapter)channelHandler).read(abstractChannelHandlerContext);
                            break block9;
                        }
                        ((ChannelOutboundHandler)channelHandler).read(abstractChannelHandlerContext);
                    }
                    catch (Throwable throwable) {
                        this.invokeExceptionCaught(throwable);
                    }
                } else {
                    abstractChannelHandlerContext.read();
                }
            } else {
                abstractChannelHandlerContext.executor().execute(this.getInvokeTasks().invokeReadTask);
            }
        }
        return this;
    }

    @Override
    public ChannelFuture write(Object object) {
        ChannelPromise channelPromise = this.newPromise();
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(65536);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            Tasks tasks = abstractChannelHandlerContext.invokeTasks;
            if (tasks == null) {
                abstractChannelHandlerContext.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, tasks.invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
        } else {
            this.flush();
        }
    }

    private void invokeFlush0() {
        try {
            ChannelHandler channelHandler = this.handler();
            DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
            if (channelHandler == headContext) {
                headContext.flush(this);
            } else if (channelHandler instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)channelHandler).flush(this);
            } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)channelHandler).flush(this);
            } else {
                ((ChannelOutboundHandler)channelHandler).flush(this);
            }
        }
        catch (Throwable throwable) {
            this.invokeExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    void write(Object object, boolean bl2, ChannelPromise channelPromise) {
        if (this.validateWrite(object, channelPromise)) {
            AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(bl2 ? 98304 : 32768);
            Object object2 = this.pipeline.touch(object, abstractChannelHandlerContext);
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                if (abstractChannelHandlerContext.invokeHandler()) {
                    try {
                        ChannelHandler channelHandler = abstractChannelHandlerContext.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (channelHandler == headContext) {
                            headContext.write(abstractChannelHandlerContext, object, channelPromise);
                        } else if (channelHandler instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)channelHandler).write(abstractChannelHandlerContext, object, channelPromise);
                        } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                            ((ChannelOutboundHandlerAdapter)channelHandler).write(abstractChannelHandlerContext, object, channelPromise);
                        } else {
                            ((ChannelOutboundHandler)channelHandler).write(abstractChannelHandlerContext, object, channelPromise);
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                    }
                    if (bl2) {
                        abstractChannelHandlerContext.invokeFlush0();
                    }
                } else {
                    abstractChannelHandlerContext.write(object, bl2, channelPromise);
                }
            } else {
                WriteTask writeTask = WriteTask.newInstance(this, object2, channelPromise, bl2);
                if (!AbstractChannelHandlerContext.safeExecute(eventExecutor, writeTask, channelPromise, object2, !bl2)) {
                    writeTask.cancel();
                }
            }
        }
    }

    private boolean validateWrite(Object object, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(object, "msg");
        try {
            if (this.isNotValidPromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        return true;
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean isNotValidPromise(ChannelPromise channelPromise, boolean bl2) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!bl2 && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.next, eventExecutor, n2, 510)) {
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound(int n2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.prev, eventExecutor, n2, 130560)) {
        }
        return abstractChannelHandlerContext;
    }

    private static boolean skipContext(AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor, int n2, int n3) {
        return (abstractChannelHandlerContext.executionMask & (n3 | n2)) == 0 || abstractChannelHandlerContext.executor() == eventExecutor && (abstractChannelHandlerContext.executionMask & n2) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int n2;
        do {
            if ((n2 = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, n2, 2));
        return true;
    }

    final void setAddPending() {
        boolean bl2 = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl2);
    }

    final void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() throws Exception {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
        }
        finally {
            this.setRemoved();
        }
    }

    boolean invokeHandler() {
        int n2 = this.handlerState;
        return n2 == 2 || !this.ordered && n2 == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object, boolean bl2) {
        try {
            if (bl2 && eventExecutor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)eventExecutor).lazyExecute(runnable);
            } else {
                eventExecutor.execute(runnable);
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                if (object != null) {
                    ReferenceCountUtil.release(object);
                }
            }
            finally {
                channelPromise.setFailure(throwable);
            }
            return false;
        }
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    Tasks getInvokeTasks() {
        Tasks tasks = this.invokeTasks;
        if (tasks == null) {
            this.invokeTasks = tasks = new Tasks(this);
        }
        return tasks;
    }

    static final class Tasks {
        final Runnable invokeChannelReadCompleteTask = abstractChannelHandlerContext::fireChannelReadComplete;
        private final Runnable invokeReadTask = abstractChannelHandlerContext::read;
        private final Runnable invokeChannelWritableStateChangedTask = abstractChannelHandlerContext::fireChannelWritabilityChanged;
        private final Runnable invokeFlushTask = () -> AbstractChannelHandlerContext.access$1000(abstractChannelHandlerContext);

        Tasks(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        }
    }

    static final class WriteTask
    implements Runnable {
        private static final Recycler<WriteTask> RECYCLER = new Recycler<WriteTask>(){

            @Override
            protected WriteTask newObject(Recycler.Handle<WriteTask> handle) {
                return new WriteTask(handle);
            }
        };
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.transport.estimateSizeOnSubmit", true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.transport.writeTaskSizeOverhead", 32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        static WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl2) {
            WriteTask writeTask = RECYCLER.get();
            WriteTask.init(writeTask, abstractChannelHandlerContext, object, channelPromise, bl2);
            return writeTask;
        }

        private WriteTask(ObjectPool.Handle<WriteTask> handle) {
            this.handle = handle;
        }

        static void init(WriteTask writeTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl2) {
            writeTask.ctx = abstractChannelHandlerContext;
            writeTask.msg = object;
            writeTask.promise = channelPromise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                writeTask.size = abstractChannelHandlerContext.pipeline.estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
                abstractChannelHandlerContext.pipeline.incrementPendingOutboundBytes(writeTask.size);
            } else {
                writeTask.size = 0;
            }
            if (bl2) {
                writeTask.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public void run() {
            try {
                this.decrementPendingOutboundBytes();
                this.ctx.write(this.msg, this.size < 0, this.promise);
            }
            finally {
                this.recycle();
            }
        }

        void cancel() {
            try {
                this.decrementPendingOutboundBytes();
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

