/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AdaptivePoolingAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnsafeByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;

public final class AdaptiveByteBufAllocator
extends AbstractByteBufAllocator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AdaptiveByteBufAllocator.class);
    private static final boolean DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.allocator.useCachedMagazinesForNonEventLoopThreads", false);
    private final AdaptivePoolingAllocator direct;
    private final AdaptivePoolingAllocator heap;

    public AdaptiveByteBufAllocator() {
        this(!PlatformDependent.isExplicitNoPreferDirect());
    }

    public AdaptiveByteBufAllocator(boolean bl2) {
        this(bl2, DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    public AdaptiveByteBufAllocator(boolean bl2, boolean bl3) {
        super(bl2);
        this.direct = new AdaptivePoolingAllocator(new DirectChunkAllocator(this), bl3);
        this.heap = new AdaptivePoolingAllocator(new HeapChunkAllocator(this), bl3);
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        return AdaptiveByteBufAllocator.toLeakAwareBuffer(this.heap.allocate(n2, n3));
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        return AdaptiveByteBufAllocator.toLeakAwareBuffer(this.direct.allocate(n2, n3));
    }

    @Override
    public boolean isDirectBufferPooled() {
        return true;
    }

    static {
        logger.debug("-Dio.netty.allocator.useCachedMagazinesForNonEventLoopThreads: {}", (Object)DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    private static final class DirectChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private DirectChunkAllocator(ByteBufAllocator byteBufAllocator) {
            this.allocator = byteBufAllocator;
        }

        @Override
        public AbstractByteBuf allocate(int n2, int n3) {
            return PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this.allocator, n2, n3) : new UnpooledDirectByteBuf(this.allocator, n2, n3);
        }
    }

    private static final class HeapChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private HeapChunkAllocator(ByteBufAllocator byteBufAllocator) {
            this.allocator = byteBufAllocator;
        }

        @Override
        public AbstractByteBuf allocate(int n2, int n3) {
            return PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf(this.allocator, n2, n3) : new UnpooledHeapByteBuf(this.allocator, n2, n3);
        }
    }
}

