/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    AbstractUnsafeSwappedByteBuf(AbstractByteBuf abstractByteBuf) {
        super(abstractByteBuf);
        assert (PlatformDependent.isUnaligned());
        this.wrapped = abstractByteBuf;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (this.order() == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final long getLong(int n2) {
        this.wrapped.checkIndex(n2, 8);
        long l2 = this._getLong(this.wrapped, n2);
        return this.nativeByteOrder ? l2 : Long.reverseBytes(l2);
    }

    @Override
    public final long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    @Override
    public final int getInt(int n2) {
        this.wrapped.checkIndex(n2, 4);
        int n3 = this._getInt(this.wrapped, n2);
        return this.nativeByteOrder ? n3 : Integer.reverseBytes(n3);
    }

    @Override
    public final int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    @Override
    public final short getShort(int n2) {
        this.wrapped.checkIndex(n2, 2);
        short s2 = this._getShort(this.wrapped, n2);
        return this.nativeByteOrder ? s2 : Short.reverseBytes(s2);
    }

    @Override
    public final ByteBuf setShort(int n2, int n3) {
        this.wrapped.checkIndex(n2, 2);
        this._setShort(this.wrapped, n2, this.nativeByteOrder ? (short)n3 : Short.reverseBytes((short)n3));
        return this;
    }

    @Override
    public final ByteBuf setInt(int n2, int n3) {
        this.wrapped.checkIndex(n2, 4);
        this._setInt(this.wrapped, n2, this.nativeByteOrder ? n3 : Integer.reverseBytes(n3));
        return this;
    }

    @Override
    public final ByteBuf setLong(int n2, long l2) {
        this.wrapped.checkIndex(n2, 8);
        this._setLong(this.wrapped, n2, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        return this;
    }

    @Override
    public final ByteBuf writeShort(int n2) {
        this.wrapped.ensureWritable0(2);
        this._setShort(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)n2 : Short.reverseBytes((short)n2));
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public final ByteBuf writeInt(int n2) {
        this.wrapped.ensureWritable0(4);
        this._setInt(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? n2 : Integer.reverseBytes(n2));
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public final ByteBuf writeLong(long l2) {
        this.wrapped.ensureWritable0(8);
        this._setLong(this.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public final ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    @Override
    public final ByteBuf writeFloat(float f2) {
        this.writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public final ByteBuf writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

