/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Strings;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.AbstractFutureState;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.DirectExecutor;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.ListenableFuture;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.NullnessCasts;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.internal.InternalFutures;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public abstract class AbstractFuture<V>
extends AbstractFutureState<V> {
    protected AbstractFuture() {
    }

    @Override
    public V get(long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        return Platform.get(this, l2, timeUnit);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return Platform.get(this);
    }

    static <V> V getDoneValue(Object object) throws ExecutionException {
        if (object instanceof Cancellation) {
            Cancellation cancellation = (Cancellation)object;
            Throwable throwable = cancellation.cause;
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", throwable);
        }
        if (object instanceof Failure) {
            Failure failure = (Failure)object;
            Throwable throwable = failure.exception;
            throw new ExecutionException(throwable);
        }
        if (object == NULL) {
            return (V)NullnessCasts.uncheckedNull();
        }
        Object object2 = object;
        return (V)object2;
    }

    static boolean notInstanceOfDelegatingToFuture(Object object) {
        return !(object instanceof DelegatingToFuture);
    }

    @Override
    public boolean isDone() {
        Object object = this.value();
        return object != null & AbstractFuture.notInstanceOfDelegatingToFuture(object);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value();
        return object instanceof Cancellation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancel(boolean bl2) {
        Object object = this.value();
        boolean bl3 = false;
        if (!(object == null | object instanceof DelegatingToFuture)) return bl3;
        Cancellation cancellation = GENERATE_CANCELLATION_CAUSES ? new Cancellation(bl2, new CancellationException("Future.cancel() was called.")) : Objects.requireNonNull(bl2 ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
        AbstractFuture abstractFuture = this;
        while (true) {
            if (AbstractFuture.casValue(abstractFuture, object, cancellation)) {
                bl3 = true;
                AbstractFuture.complete(abstractFuture, bl2);
                if (!(object instanceof DelegatingToFuture)) return bl3;
                ListenableFuture listenableFuture = ((DelegatingToFuture)object).future;
                if (listenableFuture instanceof Trusted) {
                    AbstractFuture abstractFuture2 = (AbstractFuture)listenableFuture;
                    object = abstractFuture2.value();
                    if (!(object == null | object instanceof DelegatingToFuture)) return bl3;
                    abstractFuture = abstractFuture2;
                    continue;
                }
                listenableFuture.cancel(bl2);
                return bl3;
            }
            object = abstractFuture.value();
            if (AbstractFuture.notInstanceOfDelegatingToFuture(object)) return bl3;
        }
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value();
        return object instanceof Cancellation && ((Cancellation)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Listener listener;
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (listener = this.listeners()) != Listener.TOMBSTONE) {
            Listener listener2 = new Listener(runnable, executor);
            do {
                listener2.next = listener;
                if (!this.casListeners(listener, listener2)) continue;
                return;
            } while ((listener = this.listeners()) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    protected boolean set(V v2) {
        Object object;
        Object object2 = object = v2 == null ? NULL : v2;
        if (AbstractFuture.casValue(this, null, object)) {
            AbstractFuture.complete(this, false);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        Failure failure = new Failure(Preconditions.checkNotNull(throwable));
        if (AbstractFuture.casValue(this, null, failure)) {
            AbstractFuture.complete(this, false);
            return true;
        }
        return false;
    }

    protected boolean setFuture(ListenableFuture<? extends V> listenableFuture) {
        Preconditions.checkNotNull(listenableFuture);
        Object object = this.value();
        if (object == null) {
            if (listenableFuture.isDone()) {
                Object object2 = AbstractFuture.getFutureValue(listenableFuture);
                if (AbstractFuture.casValue(this, null, object2)) {
                    AbstractFuture.complete(this, false);
                    return true;
                }
                return false;
            }
            DelegatingToFuture<? extends V> delegatingToFuture = new DelegatingToFuture<V>(this, listenableFuture);
            if (AbstractFuture.casValue(this, null, delegatingToFuture)) {
                try {
                    listenableFuture.addListener(delegatingToFuture, DirectExecutor.INSTANCE);
                }
                catch (Throwable throwable) {
                    Failure failure;
                    try {
                        failure = new Failure(throwable);
                    }
                    catch (Error | Exception throwable2) {
                        failure = Failure.FALLBACK_INSTANCE;
                    }
                    boolean bl2 = AbstractFuture.casValue(this, delegatingToFuture, failure);
                }
                return true;
            }
            object = this.value();
        }
        if (object instanceof Cancellation) {
            listenableFuture.cancel(((Cancellation)object).wasInterrupted);
        }
        return false;
    }

    private static Object getFutureValue(ListenableFuture<?> listenableFuture) {
        boolean bl2;
        Throwable throwable;
        if (listenableFuture instanceof Trusted) {
            Object object = ((AbstractFuture)listenableFuture).value();
            if (object instanceof Cancellation) {
                Cancellation cancellation = (Cancellation)object;
                if (cancellation.wasInterrupted) {
                    object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            return Objects.requireNonNull(object);
        }
        if (listenableFuture instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)listenableFuture))) != null) {
            return new Failure(throwable);
        }
        if (!GENERATE_CANCELLATION_CAUSES & (bl2 = listenableFuture.isCancelled())) {
            return Objects.requireNonNull(Cancellation.CAUSELESS_CANCELLED);
        }
        try {
            Object obj = AbstractFuture.getUninterruptibly(listenableFuture);
            if (bl2) {
                return new Cancellation(false, new IllegalArgumentException("get() did not throw CancellationException, despite reporting isCancelled() == true: " + listenableFuture));
            }
            return obj == null ? NULL : obj;
        }
        catch (ExecutionException executionException) {
            if (bl2) {
                return new Cancellation(false, new IllegalArgumentException("get() did not throw CancellationException, despite reporting isCancelled() == true: " + listenableFuture, executionException));
            }
            return new Failure(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            if (!bl2) {
                return new Failure(new IllegalArgumentException("get() threw CancellationException, despite reporting isCancelled() == false: " + listenableFuture, cancellationException));
            }
            return new Cancellation(false, cancellationException);
        }
        catch (Error | Exception throwable2) {
            return new Failure(throwable2);
        }
    }

    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl2 = false;
        while (true) {
            try {
                V v2 = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Platform.interruptCurrentThread();
            }
        }
    }

    private static void complete(AbstractFuture<?> abstractFuture, boolean bl2) {
        AbstractFuture<Object> abstractFuture2 = abstractFuture;
        Listener listener = null;
        block0: while (true) {
            abstractFuture2.releaseWaiters();
            if (bl2) {
                abstractFuture2.interruptTask();
                bl2 = false;
            }
            abstractFuture2.afterDone();
            listener = super.clearListeners(listener);
            abstractFuture2 = null;
            while (listener != null) {
                Listener listener2 = listener;
                listener = listener.next;
                Runnable runnable = Objects.requireNonNull(listener2.task);
                if (runnable instanceof DelegatingToFuture) {
                    Object object;
                    DelegatingToFuture delegatingToFuture = (DelegatingToFuture)runnable;
                    abstractFuture2 = delegatingToFuture.owner;
                    if (abstractFuture2.value() != delegatingToFuture || !AbstractFuture.casValue(abstractFuture2, delegatingToFuture, object = AbstractFuture.getFutureValue(delegatingToFuture.future))) continue;
                    continue block0;
                }
                AbstractFuture.executeListener(runnable, Objects.requireNonNull(listener2.executor));
            }
            break;
        }
    }

    protected void afterDone() {
    }

    @Override
    protected final Throwable tryInternalFastPathGetFailure() {
        Object object;
        if (this instanceof Trusted && (object = this.value()) instanceof Failure) {
            return ((Failure)object).exception;
        }
        return null;
    }

    final void maybePropagateCancellationTo(Future<?> future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    private Listener clearListeners(Listener listener) {
        Listener listener2 = this.gasListeners(Listener.TOMBSTONE);
        Listener listener3 = listener;
        while (listener2 != null) {
            Listener listener4 = listener2;
            listener2 = listener2.next;
            listener4.next = listener3;
            listener3 = listener4;
        }
        return listener3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getClass().getName().startsWith("com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.")) {
            stringBuilder.append(this.getClass().getSimpleName());
        } else {
            stringBuilder.append(this.getClass().getName());
        }
        stringBuilder.append('@').append(Integer.toHexString(System.identityHashCode(this))).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            this.addPendingString(stringBuilder);
        }
        return stringBuilder.append("]").toString();
    }

    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            return "remaining delay=[" + ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS) + " ms]";
        }
        return null;
    }

    private void addPendingString(StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        stringBuilder.append("PENDING");
        Object object = this.value();
        if (object instanceof DelegatingToFuture) {
            stringBuilder.append(", setFuture=[");
            this.appendUserObject(stringBuilder, ((DelegatingToFuture)object).future);
            stringBuilder.append("]");
        } else {
            String string;
            try {
                string = Strings.emptyToNull(this.pendingToString());
            }
            catch (Throwable throwable) {
                Platform.rethrowIfErrorOtherThanStackOverflow(throwable);
                string = "Exception thrown from implementation: " + throwable.getClass();
            }
            if (string != null) {
                stringBuilder.append(", info=[").append(string).append("]");
            }
        }
        if (this.isDone()) {
            stringBuilder.delete(n2, stringBuilder.length());
            this.addDoneString(stringBuilder);
        }
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            V v2 = AbstractFuture.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            this.appendResultObject(stringBuilder, v2);
            stringBuilder.append("]");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (Exception exception) {
            stringBuilder.append("UNKNOWN, cause=[").append(exception.getClass()).append(" thrown from get()]");
        }
    }

    private void appendResultObject(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object == this) {
            stringBuilder.append("this future");
        } else {
            stringBuilder.append(object.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    private void appendUserObject(StringBuilder stringBuilder, Object object) {
        try {
            if (object == this) {
                stringBuilder.append("this future");
            } else {
                stringBuilder.append(object);
            }
        }
        catch (Throwable throwable) {
            Platform.rethrowIfErrorOtherThanStackOverflow(throwable);
            stringBuilder.append("Exception thrown from implementation: ").append(throwable.getClass());
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (Exception exception) {
            log.get().log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, exception);
        }
    }

    private static CancellationException cancellationExceptionWithCause(String string, Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    private static final class DelegatingToFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        DelegatingToFuture(AbstractFuture<V> abstractFuture, ListenableFuture<? extends V> listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (this.owner.value() != this) {
                return;
            }
            Object object = AbstractFuture.getFutureValue(this.future);
            if (AbstractFutureState.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner, false);
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        Cancellation(boolean bl2, Throwable throwable) {
            this.wasInterrupted = bl2;
            this.cause = throwable;
        }

        static {
            if (AbstractFutureState.GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = Preconditions.checkNotNull(throwable);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }

    static final class Listener {
        static final Listener TOMBSTONE = new Listener();
        final Runnable task;
        final Executor executor;
        Listener next;

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }

        Listener() {
            this.task = null;
            this.executor = null;
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        TrustedFuture() {
        }

        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l2, timeUnit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl2) {
            return super.cancel(bl2);
        }
    }
}

