/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Throwables;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;

public final class Closer
implements Closeable {
    final Suppressor suppressor;
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    private Throwable thrown;
    private static final Suppressor SUPPRESSING_SUPPRESSOR = (closeable, throwable, throwable2) -> {
        if (throwable == throwable2) {
            return;
        }
        try {
            throwable.addSuppressed(throwable2);
        }
        catch (Throwable throwable3) {
            Closeables.logger.log(Level.WARNING, "Suppressing exception thrown when closing " + closeable, throwable2);
        }
    };

    public static Closer create() {
        return new Closer(SUPPRESSING_SUPPRESSOR);
    }

    Closer(Suppressor suppressor) {
        this.suppressor = Preconditions.checkNotNull(suppressor);
    }

    public <C extends Closeable> C register(C c2) {
        if (c2 != null) {
            this.stack.addFirst(c2);
        }
        return c2;
    }

    public RuntimeException rethrow(Throwable throwable) throws IOException {
        Preconditions.checkNotNull(throwable);
        this.thrown = throwable;
        Throwables.throwIfInstanceOf(throwable, IOException.class);
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    continue;
                }
                this.suppressor.suppress(closeable, throwable, throwable2);
            }
        }
        if (this.thrown == null && throwable != null) {
            Throwables.throwIfInstanceOf(throwable, IOException.class);
            Throwables.throwIfUnchecked(throwable);
            throw new AssertionError((Object)throwable);
        }
    }

    static interface Suppressor {
        public void suppress(Closeable var1, Throwable var2, Throwable var3);
    }
}

