/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.PotentialCreators;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Converter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    private static final Class<?>[] NO_VIEWS = new Class[0];
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected Class<?>[] _defaultViews;
    protected boolean _defaultViewsResolved;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector, JavaType javaType, AnnotatedClass annotatedClass) {
        super(javaType);
        this._propCollector = pOJOPropertiesCollector;
        this._config = pOJOPropertiesCollector.getConfig();
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
    }

    protected BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list) {
        super(javaType);
        this._propCollector = null;
        this._config = mapperConfig;
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        this(pOJOPropertiesCollector, pOJOPropertiesCollector.getType(), pOJOPropertiesCollector.getClassDef());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, Collections.emptyList());
    }

    protected List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    public boolean removeProperty(String string) {
        Iterator<BeanPropertyDefinition> iterator = this._properties().iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (!beanPropertyDefinition.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMember findJsonKeyAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonKeyAccessor();
    }

    @Override
    public AnnotatedMember findJsonValueAccessor() {
        return this._propCollector == null ? null : this._propCollector.getJsonValueAccessor();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Set<String> set;
        Set<String> set2 = set = this._propCollector == null ? null : this._propCollector.getIgnoredPropertyNames();
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMember findAnySetterAccessor() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMethod annotatedMethod = this._propCollector.getAnySetterMethod();
            if (annotatedMethod != null) {
                Class<?> clazz = annotatedMethod.getRawParameterType(0);
                if (clazz != String.class && clazz != Object.class) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on method '%s()': first argument not of type String or Object, but %s", annotatedMethod.getName(), clazz.getName()));
                }
                return annotatedMethod;
            }
            AnnotatedMember annotatedMember = this._propCollector.getAnySetterField();
            if (annotatedMember != null) {
                Class<?> clazz = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom(clazz) && !JsonNode.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on field '%s': type is not instance of `java.util.Map` or `JsonNode`", annotatedMember.getName()));
                }
                return annotatedMember;
            }
        }
        return null;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        if (this._propCollector != null) {
            return this._propCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode() {
        List<AnnotatedConstructor> list = this._classInfo.getConstructors();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> arrayList = new ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>>();
        for (AnnotatedConstructor annotatedConstructor : list) {
            JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedConstructor);
            if (mode == JsonCreator.Mode.DISABLED) continue;
            arrayList.add(AnnotatedAndMetadata.of(annotatedConstructor, mode));
        }
        return arrayList;
    }

    @Override
    public PotentialCreators getPotentialCreators() {
        if (this._propCollector == null) {
            return new PotentialCreators();
        }
        return this._propCollector.getPotentialCreators();
    }

    @Override
    public Object instantiateBean(boolean bl2) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl2) {
            annotatedConstructor.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return annotatedConstructor.call();
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            ClassUtil.throwIfError(throwable);
            ClassUtil.throwIfRTE(throwable);
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + ClassUtil.exceptionMessage(throwable), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat() {
        if (this._propCollector == null) {
            return JsonFormat.Value.empty();
        }
        return this._propCollector.getFormatOverrides();
    }

    @Override
    public Class<?>[] findDefaultViews() {
        if (!this._defaultViewsResolved) {
            Class<?>[] classArray;
            this._defaultViewsResolved = true;
            Class<?>[] classArray2 = classArray = this._annotationIntrospector == null ? null : this._annotationIntrospector.findViews(this._classInfo);
            if (classArray == null && !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                classArray = NO_VIEWS;
            }
            this._defaultViews = classArray;
        }
        return this._defaultViews;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value value) {
        JsonInclude.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findPropertyInclusion(this._classInfo)) != null) {
            return value == null ? value2 : value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public AnnotatedMember findAnyGetter() throws IllegalArgumentException {
        if (this._propCollector != null) {
            AnnotatedMember annotatedMember = this._propCollector.getAnyGetterMethod();
            if (annotatedMember != null) {
                Class<?> clazz = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on method %s(): return type is not instance of java.util.Map", annotatedMember.getName()));
                }
                return annotatedMember;
            }
            AnnotatedMember annotatedMember2 = this._propCollector.getAnyGetterField();
            if (annotatedMember2 != null) {
                Class<?> clazz = annotatedMember2.getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on field '%s': type is not instance of java.util.Map", annotatedMember2.getName()));
                }
                return annotatedMember2;
            }
        }
        return null;
    }

    @Override
    public List<BeanPropertyDefinition> findBackReferences() {
        ArrayList<BeanPropertyDefinition> arrayList = null;
        HashSet<String> hashSet = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty == null || !referenceProperty.isBackReference()) continue;
            String string = referenceProperty.getName();
            if (arrayList == null) {
                arrayList = new ArrayList<BeanPropertyDefinition>();
                hashSet = new HashSet<String>();
                hashSet.add(string);
            } else if (!hashSet.add(string)) {
                throw new IllegalArgumentException("Multiple back-reference properties with name " + ClassUtil.name(string));
            }
            arrayList.add(beanPropertyDefinition);
        }
        return arrayList;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> list = this._classInfo.getFactoryMethods();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<AnnotatedMethod> arrayList = null;
        for (AnnotatedMethod annotatedMethod : list) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedMethod>();
            }
            arrayList.add(annotatedMethod);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode() {
        List<AnnotatedMethod> list = this._classInfo.getFactoryMethods();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> arrayList = null;
        for (AnnotatedMethod annotatedMethod : list) {
            AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> annotatedAndMetadata = this.findFactoryMethodMetadata(annotatedMethod);
            if (annotatedAndMetadata == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>>();
            }
            arrayList.add(annotatedAndMetadata);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        Class<?> clazz2 = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz2)) {
            return false;
        }
        JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedMethod);
        if (mode != null && mode != JsonCreator.Mode.DISABLED) {
            return true;
        }
        String string = annotatedMethod.getName();
        if ("valueOf".equals(string) && annotatedMethod.getParameterCount() == 1) {
            return true;
        }
        return "fromString".equals(string) && annotatedMethod.getParameterCount() == 1 && ((clazz = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz));
    }

    protected AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> findFactoryMethodMetadata(AnnotatedMethod annotatedMethod) {
        Class<?> clazz;
        Class<?> clazz2 = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz2)) {
            return null;
        }
        JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedMethod);
        if (mode != null) {
            if (mode == JsonCreator.Mode.DISABLED) {
                return null;
            }
            return AnnotatedAndMetadata.of(annotatedMethod, mode);
        }
        String string = annotatedMethod.getName();
        if ("valueOf".equals(string) && annotatedMethod.getParameterCount() == 1) {
            return AnnotatedAndMetadata.of(annotatedMethod, mode);
        }
        if ("fromString".equals(string) && annotatedMethod.getParameterCount() == 1 && ((clazz = annotatedMethod.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz))) {
            return AnnotatedAndMetadata.of(annotatedMethod, mode);
        }
        return null;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._createConverter(this._annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    protected Converter<Object, Object> _createConverter(Object object) {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(this._config, this._classInfo, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return converter;
    }
}

