/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JacksonException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;

class FactoryBasedEnumDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    protected final JavaType _inputType;
    protected final AnnotatedMethod _factory;
    protected final JsonDeserializer<?> _deser;
    protected final ValueInstantiator _valueInstantiator;
    protected final SettableBeanProperty[] _creatorProps;
    protected final Enum<?> _defaultValue;
    protected final boolean _hasArgs;
    private volatile transient PropertyBasedCreator _propCreator;

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, JavaType javaType, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, EnumResolver enumResolver) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = true;
        this._inputType = javaType.hasRawClass(String.class) || javaType.hasRawClass(CharSequence.class) ? null : javaType;
        this._deser = null;
        this._valueInstantiator = valueInstantiator;
        this._creatorProps = settableBeanPropertyArray;
        this._defaultValue = enumResolver == null ? null : enumResolver.getDefaultValue();
    }

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = false;
        this._inputType = null;
        this._deser = null;
        this._valueInstantiator = null;
        this._creatorProps = null;
        this._defaultValue = null;
    }

    protected FactoryBasedEnumDeserializer(FactoryBasedEnumDeserializer factoryBasedEnumDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(factoryBasedEnumDeserializer._valueClass);
        this._inputType = factoryBasedEnumDeserializer._inputType;
        this._factory = factoryBasedEnumDeserializer._factory;
        this._hasArgs = factoryBasedEnumDeserializer._hasArgs;
        this._valueInstantiator = factoryBasedEnumDeserializer._valueInstantiator;
        this._creatorProps = factoryBasedEnumDeserializer._creatorProps;
        this._defaultValue = factoryBasedEnumDeserializer._defaultValue;
        this._deser = jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._deser == null && this._inputType != null && this._creatorProps == null) {
            return new FactoryBasedEnumDeserializer(this, deserializationContext.findContextualValueDeserializer(this._inputType, beanProperty));
        }
        return this;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (this._deser != null) {
            object = this._deser.deserialize(jsonParser, deserializationContext);
        } else if (this._hasArgs) {
            JsonToken jsonToken;
            boolean bl2;
            if (this._creatorProps != null) {
                if (jsonParser.isExpectedStartObjectToken()) {
                    PropertyBasedCreator propertyBasedCreator = this._propCreator;
                    if (propertyBasedCreator == null) {
                        this._propCreator = propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, this._creatorProps, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
                    }
                    jsonParser.nextToken();
                    return this.deserializeEnumUsingPropertyBased(jsonParser, deserializationContext, propertyBasedCreator);
                }
                if (!this._valueInstantiator.canCreateFromString()) {
                    JavaType javaType = this.getValueType(deserializationContext);
                    JsonToken jsonToken2 = jsonParser.currentToken();
                    return deserializationContext.reportInputMismatch(javaType, "Input mismatch reading Enum %s: properties-based `@JsonCreator` (%s) expects Object Value, got %s (`JsonToken.%s`)", ClassUtil.getTypeDescription(javaType), this._factory, JsonToken.valueDescFor(jsonToken2), jsonToken2.name());
                }
            }
            boolean bl3 = bl2 = (jsonToken = jsonParser.currentToken()) == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
            if (bl2) {
                jsonToken = jsonParser.nextToken();
            }
            if (jsonToken == JsonToken.START_OBJECT) {
                object = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                if (object == null) {
                    return deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
                }
            } else {
                if (jsonToken == null || !jsonToken.isScalarValue()) {
                    JavaType javaType = this.getValueType(deserializationContext);
                    return deserializationContext.reportInputMismatch(javaType, "Input mismatch reading Enum %s: properties-based `@JsonCreator` (%s) expects String Value, got %s (`JsonToken.%s`)", ClassUtil.getTypeDescription(javaType), this._factory, JsonToken.valueDescFor(jsonToken), jsonToken.name());
                }
                object = jsonParser.getValueAsString();
            }
            if (bl2 && jsonParser.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
        } else {
            jsonParser.skipChildren();
            try {
                return this._factory.call();
            }
            catch (Exception exception) {
                Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
                return deserializationContext.handleInstantiationProblem(this._valueClass, null, throwable);
            }
        }
        try {
            return this._factory.callOnWith(this._valueClass, object);
        }
        catch (Exception exception) {
            Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
            if (throwable instanceof IllegalArgumentException) {
                if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE) && this._defaultValue != null) {
                    return this._defaultValue;
                }
                if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    return null;
                }
            }
            return deserializationContext.handleInstantiationProblem(this._valueClass, object, throwable);
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected Object deserializeEnumUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyBasedCreator propertyBasedCreator) throws IOException {
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonToken jsonToken = jsonParser.currentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
            if (!propertyValueBuffer.readIdProperty(string) || settableBeanProperty != null) {
                if (settableBeanProperty != null) {
                    propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty));
                } else {
                    jsonParser.skipChildren();
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        return propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser jsonParser, DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws IOException {
        try {
            return settableBeanProperty.deserialize(jsonParser, deserializationContext);
        }
        catch (Exception exception) {
            return this.wrapAndThrow(exception, this.handledType(), settableBeanProperty.getName(), deserializationContext);
        }
    }

    protected Object wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        throwable = ClassUtil.getRootCause(throwable);
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        return throwable;
    }
}

