/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue propertyValue, Object object) {
        this.next = propertyValue;
        this.value = object;
    }

    public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object object) throws IOException {
        throw new UnsupportedOperationException("Should not be called on type: " + this.getClass().getName());
    }

    static final class Merging
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Merging(PropertyValue propertyValue, TokenBuffer tokenBuffer, SettableBeanProperty settableBeanProperty) {
            super(propertyValue, tokenBuffer);
            this._property = settableBeanProperty;
        }

        @Override
        public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
            TokenBuffer tokenBuffer = (TokenBuffer)this.value;
            try (JsonParser jsonParser = tokenBuffer.asParser();){
                jsonParser.nextToken();
                this._property.deserializeAndSet(jsonParser, deserializationContext, object);
            }
        }
    }

    static final class AnyParameter
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public AnyParameter(PropertyValue propertyValue, Object object, SettableAnyProperty settableAnyProperty, String string) {
            super(propertyValue, object);
            this._property = settableAnyProperty;
            this._propertyName = string;
        }

        @Override
        public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
        }

        @Override
        public void setValue(Object object) throws IOException {
            this._property.set(object, this._propertyName, this.value);
        }
    }

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue propertyValue, Object object, Object object2) {
            super(propertyValue, object);
            this._key = object2;
        }

        @Override
        public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
            ((java.util.Map)object).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue propertyValue, Object object, SettableAnyProperty settableAnyProperty, String string) {
            super(propertyValue, object);
            this._property = settableAnyProperty;
            this._propertyName = string;
        }

        @Override
        public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
            this._property.set(object, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue propertyValue, Object object, SettableBeanProperty settableBeanProperty) {
            super(propertyValue, object);
            this._property = settableBeanProperty;
        }

        @Override
        public void assign(DeserializationContext deserializationContext, Object object) throws IOException {
            this._property.set(object, this.value);
        }
    }
}

