/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.base;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadConstraints;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.InputCoercionException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.JsonEOFException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final byte[] NO_BYTES = new byte[0];
    protected static final int[] NO_INTS = new int[0];
    protected static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    protected static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    protected static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    protected static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    protected final StreamReadConstraints _streamReadConstraints;
    protected JsonToken _currToken;
    protected long _tokenCount;
    protected final boolean _trackMaxTokenCount;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase(StreamReadConstraints streamReadConstraints) {
        this._streamReadConstraints = streamReadConstraints == null ? StreamReadConstraints.defaults() : streamReadConstraints;
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    protected ParserMinimalBase(int n2, StreamReadConstraints streamReadConstraints) {
        super(n2);
        this._streamReadConstraints = streamReadConstraints == null ? StreamReadConstraints.defaults() : streamReadConstraints;
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    @Override
    public StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    @Override
    public abstract JsonToken nextToken() throws IOException;

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public int currentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    @Deprecated
    public int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0 == n2;
        }
        return jsonToken.id() == n2;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        return this._currToken == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonToken nextValue() throws IOException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken.isStructEnd()) {
                if (--n2 != 0) continue;
                return this;
            }
            if (jsonToken != JsonToken.NOT_AVAILABLE) continue;
            this._reportError("Not enough content available for `skipChildren()`: non-blocking parser? (%s)", this.getClass().getName());
        }
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public abstract String getText() throws IOException;

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return this.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(string, n2);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n2;
    }

    @Override
    public long getValueAsLong() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return this.getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long l2) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                case 6: {
                    String string = this.getText();
                    if (this._hasTextualNull(string)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(string, l2);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l2;
    }

    @Override
    public String getValueAsString() throws IOException {
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return string;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException {
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
        }
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected void _reportInputCoercion(String string, JsonToken jsonToken, Class<?> clazz) throws InputCoercionException {
        throw new InputCoercionException((JsonParser)this, string, jsonToken, clazz);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken), this._currToken);
    }

    protected void _reportInvalidEOFInValue(JsonToken jsonToken) throws JsonParseException {
        String string = jsonToken == JsonToken.VALUE_STRING ? " in a String value" : (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT ? " in a Number value" : " in a value");
        this._reportInvalidEOF(string, jsonToken);
    }

    protected void _reportInvalidEOF(String string, JsonToken jsonToken) throws JsonParseException {
        throw new JsonEOFException((JsonParser)this, jsonToken, "Unexpected end-of-input" + string);
    }

    protected void reportInvalidNumber(String string) throws JsonParseException {
        throw this._constructReadException("Invalid numeric value: " + string);
    }

    protected void _reportMissingRootWS(int n2) throws JsonParseException {
        this._reportUnexpectedChar(n2, "Expected space separating root-level values");
    }

    protected void reportOverflowInt() throws IOException {
        this.reportOverflowInt(this.getText());
    }

    protected void reportOverflowInt(String string) throws IOException {
        this.reportOverflowInt(string, this.currentToken());
    }

    protected void reportOverflowInt(String string, JsonToken jsonToken) throws IOException {
        this._reportInputCoercion(String.format("Numeric value (%s) out of range of int (%d - %s)", this._longIntegerDesc(string), Integer.MIN_VALUE, Integer.MAX_VALUE), jsonToken, Integer.TYPE);
    }

    protected void reportOverflowLong() throws IOException {
        this.reportOverflowLong(this.getText());
    }

    protected void reportOverflowLong(String string) throws IOException {
        this.reportOverflowLong(string, this.currentToken());
    }

    protected void reportOverflowLong(String string, JsonToken jsonToken) throws IOException {
        this._reportInputCoercion(String.format("Numeric value (%s) out of range of long (%d - %s)", this._longIntegerDesc(string), Long.MIN_VALUE, Long.MAX_VALUE), jsonToken, Long.TYPE);
    }

    protected String _longIntegerDesc(String string) {
        int n2 = string.length();
        if (n2 < 1000) {
            return string;
        }
        if (string.startsWith("-")) {
            --n2;
        }
        return String.format("[Integer with %d digits]", n2);
    }

    protected String _longNumberDesc(String string) {
        int n2 = string.length();
        if (n2 < 1000) {
            return string;
        }
        if (string.startsWith("-")) {
            --n2;
        }
        return String.format("[number with %d characters]", n2);
    }

    protected void _reportUnexpectedChar(int n2, String string) throws JsonParseException {
        if (n2 < 0) {
            this._reportInvalidEOF();
        }
        String string2 = String.format("Unexpected character (%s)", ParserMinimalBase._getCharDesc(n2));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructReadException(string2, this._currentLocationMinusOne());
    }

    protected <T> T _reportUnexpectedNumberChar(int n2, String string) throws JsonParseException {
        String string2 = String.format("Unexpected character (%s) in numeric value", ParserMinimalBase._getCharDesc(n2));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructReadException(string2, this._currentLocationMinusOne());
    }

    protected void _throwInvalidSpace(int n2) throws JsonParseException {
        char c2 = (char)n2;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        if (n2 == 30) {
            string = string + " (consider enabling `JsonReadFeature.ALLOW_RS_CONTROL_CHAR` to allow use of Record Separators (\\u001E))";
        }
        throw this._constructReadException(string);
    }

    protected JsonLocation _currentLocationMinusOne() {
        return this.currentLocation();
    }

    protected static final String _getCharDesc(int n2) {
        char c2 = (char)n2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + n2 + ")";
        }
        if (n2 > 255) {
            return "'" + c2 + "' (code " + n2 + " / 0x" + Integer.toHexString(n2) + ")";
        }
        return "'" + c2 + "' (code " + n2 + ")";
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw this._constructReadException(string);
    }

    protected final void _reportError(String string, Object object) throws JsonParseException {
        throw this._constructReadException(string, object);
    }

    protected final void _reportError(String string, Object object, Object object2) throws JsonParseException {
        throw this._constructReadException(string, object, object2);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final void _wrapError(String string, Throwable throwable) throws JsonParseException {
        throw this._constructReadException(string, throwable);
    }

    protected final JsonToken _updateToken(JsonToken jsonToken) throws StreamConstraintsException {
        this._currToken = jsonToken;
        if (this._trackMaxTokenCount) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return jsonToken;
    }

    protected final JsonToken _nullSafeUpdateToken(JsonToken jsonToken) throws StreamConstraintsException {
        this._currToken = jsonToken;
        if (this._trackMaxTokenCount && jsonToken != null) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return jsonToken;
    }

    protected final JsonToken _updateTokenToNull() {
        this._currToken = null;
        return null;
    }
}

