/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class RecordSerializer<T>
extends ImmutableSerializer<T> {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private static final ClassValue<Constructor<?>> CONSTRUCTOR;
    private static final ClassValue<RecordComponent[]> RECORD_COMPONENTS;
    private boolean fixedFieldTypes = false;

    @Deprecated(forRemoval=true)
    public RecordSerializer() {
    }

    @Override
    public void write(Kryo kryo, Output output, T t2) {
        for (RecordComponent recordComponent : RECORD_COMPONENTS.get(t2.getClass())) {
            Class<?> clazz = recordComponent.type();
            String string = recordComponent.name();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write property: " + string + " (" + clazz.getName() + ")");
                }
                if (clazz.isPrimitive()) {
                    kryo.writeObject(output, recordComponent.getValue(t2));
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(clazz)) {
                    kryo.writeObjectOrNull(output, recordComponent.getValue(t2), clazz);
                    continue;
                }
                kryo.writeClassAndObject(output, recordComponent.getValue(t2));
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(string + " (" + clazz.getName() + ")");
                throw kryoException;
            }
            catch (Throwable throwable) {
                KryoException kryoException = new KryoException(throwable);
                kryoException.addTrace(string + " (" + clazz.getName() + ")");
                throw kryoException;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> clazz) {
        RecordComponent[] recordComponentArray = RECORD_COMPONENTS.get(clazz);
        Object[] objectArray = new Object[recordComponentArray.length];
        for (int i2 = 0; i2 < recordComponentArray.length; ++i2) {
            RecordComponent recordComponent = recordComponentArray[i2];
            String string = recordComponent.name();
            Class<?> clazz2 = recordComponent.type();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Read property: " + string + " (" + clazz.getName() + ")");
                }
                if (clazz2.isPrimitive()) {
                    objectArray[recordComponent.index()] = kryo.readObject(input, clazz2);
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(clazz2)) {
                    objectArray[recordComponent.index()] = kryo.readObjectOrNull(input, clazz2);
                    continue;
                }
                objectArray[recordComponent.index()] = kryo.readClassAndObject(input);
                continue;
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(string + " (" + clazz.getName() + ")");
                throw kryoException;
            }
            catch (Throwable throwable) {
                KryoException kryoException = new KryoException(throwable);
                kryoException.addTrace(string + " (" + clazz.getName() + ")");
                throw kryoException;
            }
        }
        return this.invokeCanonicalConstructor(clazz, objectArray);
    }

    private static <T> RecordComponent[] recordComponents(Class<T> clazz, Comparator<RecordComponent> comparator) {
        try {
            Object[] objectArray = (Object[])GET_RECORD_COMPONENTS.invoke(clazz, new Object[0]);
            RecordComponent[] recordComponentArray = new RecordComponent[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                recordComponentArray[i2] = new RecordComponent(clazz, (String)GET_NAME.invoke(object, new Object[0]), (Class)GET_TYPE.invoke(object, new Object[0]), i2);
            }
            if (comparator != null) {
                Arrays.sort(recordComponentArray, comparator);
            }
            return recordComponentArray;
        }
        catch (Throwable throwable) {
            KryoException kryoException = new KryoException(throwable);
            kryoException.addTrace("Could not retrieve record components (" + clazz.getName() + ")");
            throw kryoException;
        }
    }

    private T invokeCanonicalConstructor(Class<? extends T> clazz, Object[] objectArray) {
        try {
            return (T)CONSTRUCTOR.get(clazz).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            KryoException kryoException = new KryoException(throwable);
            kryoException.addTrace("Could not construct type (" + clazz.getName() + ")");
            throw kryoException;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> clazz, RecordComponent[] recordComponentArray) {
        try {
            Class[] classArray = (Class[])Arrays.stream(recordComponentArray).map(RecordComponent::type).toArray(Class[]::new);
            return RecordSerializer.getCanonicalConstructor(clazz, classArray);
        }
        catch (Throwable throwable) {
            KryoException kryoException = new KryoException(throwable);
            kryoException.addTrace("Could not retrieve record canonical constructor (" + clazz.getName() + ")");
            throw kryoException;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> clazz, Class<?>[] classArray) throws NoSuchMethodException {
        Constructor<T> constructor;
        try {
            constructor = clazz.getConstructor(classArray);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
        }
        catch (Exception exception) {
            constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
        }
        return constructor;
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Method method4;
        try {
            Class<?> clazz = Class.forName("java.lang.reflect.RecordComponent");
            method4 = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            method3 = Class.class.getMethod("getRecordComponents", new Class[0]);
            method2 = clazz.getMethod("getName", new Class[0]);
            method = clazz.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            method4 = null;
            method3 = null;
            method2 = null;
            method = null;
        }
        IS_RECORD = method4;
        GET_RECORD_COMPONENTS = method3;
        GET_NAME = method2;
        GET_TYPE = method;
        CONSTRUCTOR = new ClassValue<Constructor<?>>(){

            @Override
            protected Constructor<?> computeValue(Class<?> clazz) {
                RecordComponent[] recordComponentArray = RecordSerializer.recordComponents(clazz, Comparator.comparing(RecordComponent::index));
                return RecordSerializer.getCanonicalConstructor(clazz, recordComponentArray);
            }
        };
        RECORD_COMPONENTS = new ClassValue<RecordComponent[]>(){

            @Override
            protected RecordComponent[] computeValue(Class<?> clazz) {
                return RecordSerializer.recordComponents(clazz, Comparator.comparing(RecordComponent::name));
            }
        };
    }

    static final class RecordComponent {
        private final Class<?> recordType;
        private final String name;
        private final Class<?> type;
        private final int index;
        private final Method getter;

        RecordComponent(Class<?> clazz, String string, Class<?> clazz2, int n2) {
            this.recordType = clazz;
            this.name = string;
            this.type = clazz2;
            this.index = n2;
            try {
                this.getter = clazz.getDeclaredMethod(string, new Class[0]);
                if (!this.getter.isAccessible()) {
                    this.getter.setAccessible(true);
                }
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace("Could not retrieve record component getter (" + clazz.getName() + ")");
                throw kryoException;
            }
        }

        String name() {
            return this.name;
        }

        Class<?> type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        Object getValue(Object object) {
            try {
                return this.getter.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                KryoException kryoException = new KryoException(exception);
                kryoException.addTrace("Could not retrieve record component value (" + this.recordType.getName() + ")");
                throw kryoException;
            }
        }
    }
}

