/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDEventListener;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedArrayDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedValueDecoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.TypedXMLStreamException;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TextBuffer {
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    static final int MAX_SEGMENT_LENGTH = 262144;
    static final int INT_SPACE = 32;
    private final ReaderConfig mConfig;
    private char[] mInputBuffer;
    private int mInputStart;
    private int mInputLen;
    private boolean mHasSegments = false;
    private ArrayList<char[]> mSegments;
    private int mSegmentSize;
    private char[] mCurrentSegment;
    private int mCurrentSize;
    private String mResultString;
    private char[] mResultArray;
    public static final int MAX_INDENT_SPACES = 32;
    public static final int MAX_INDENT_TABS = 8;
    private static final String sIndSpaces = "\n                                 ";
    private static final char[] sIndSpacesArray = "\n                                 ".toCharArray();
    private static final String[] sIndSpacesStrings = new String[sIndSpacesArray.length];
    private static final String sIndTabs = "\n\t\t\t\t\t\t\t\t\t";
    private static final char[] sIndTabsArray = "\n\t\t\t\t\t\t\t\t\t".toCharArray();
    private static final String[] sIndTabsStrings = new String[sIndTabsArray.length];

    private TextBuffer(ReaderConfig readerConfig) {
        this.mConfig = readerConfig;
    }

    public static TextBuffer createRecyclableBuffer(ReaderConfig readerConfig) {
        return new TextBuffer(readerConfig);
    }

    public static TextBuffer createTemporaryBuffer() {
        return new TextBuffer(null);
    }

    public void recycle(boolean bl2) {
        if (this.mConfig != null && this.mCurrentSegment != null) {
            if (bl2) {
                this.resetWithEmpty();
            } else {
                if (this.mInputStart < 0 && this.mSegmentSize + this.mCurrentSize > 0) {
                    return;
                }
                if (this.mSegments != null && this.mSegments.size() > 0) {
                    this.mSegments.clear();
                    this.mSegmentSize = 0;
                }
            }
            char[] cArray = this.mCurrentSegment;
            this.mCurrentSegment = null;
            this.mConfig.freeMediumCBuffer(cArray);
        }
    }

    public void resetWithEmpty() {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
        this.mCurrentSize = 0;
    }

    public void resetWithEmptyString() {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = "";
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
        this.mCurrentSize = 0;
    }

    public void resetWithShared(char[] cArray, int n2, int n3) {
        this.mInputBuffer = cArray;
        this.mInputStart = n2;
        this.mInputLen = n3;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithCopy(char[] cArray, int n2, int n3) {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
        if (this.mCurrentSegment == null) {
            this.mCurrentSegment = this.allocBuffer(n3);
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
        this.append(cArray, n2, n3);
    }

    public void resetInitialized() {
        this.resetWithEmpty();
        if (this.mCurrentSegment == null) {
            this.mCurrentSegment = this.allocBuffer(0);
        }
    }

    private final char[] allocBuffer(int n2) {
        int n3 = Math.max(n2, 500);
        char[] cArray = null;
        if (this.mConfig != null && (cArray = this.mConfig.allocMediumCBuffer(n3)) != null) {
            return cArray;
        }
        return new char[n3];
    }

    private final void clearSegments() {
        this.mHasSegments = false;
        this.mSegments.clear();
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
    }

    public void resetWithIndentation(int n2, char c2) {
        String string;
        this.mInputStart = 0;
        this.mInputLen = n2 + 1;
        if (c2 == '\t') {
            this.mInputBuffer = sIndTabsArray;
            string = sIndTabsStrings[n2];
            if (string == null) {
                TextBuffer.sIndTabsStrings[n2] = string = sIndTabs.substring(0, this.mInputLen);
            }
        } else {
            this.mInputBuffer = sIndSpacesArray;
            string = sIndSpacesStrings[n2];
            if (string == null) {
                TextBuffer.sIndSpacesStrings[n2] = string = sIndSpaces.substring(0, this.mInputLen);
            }
        }
        this.mResultString = string;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mSegments.clear();
            this.mSegmentSize = 0;
            this.mCurrentSize = 0;
        }
    }

    public int size() {
        if (this.mInputStart >= 0) {
            return this.mInputLen;
        }
        return this.mSegmentSize + this.mCurrentSize;
    }

    public int getTextStart() {
        return this.mInputStart >= 0 ? this.mInputStart : 0;
    }

    public char[] getTextBuffer() {
        if (this.mInputStart >= 0) {
            return this.mInputBuffer;
        }
        if (this.mSegments == null || this.mSegments.size() == 0) {
            return this.mCurrentSegment;
        }
        return this.contentsAsArray();
    }

    public void decode(TypedValueDecoder typedValueDecoder) throws IllegalArgumentException {
        int n2;
        int n3;
        char[] cArray;
        if (this.mInputStart >= 0) {
            cArray = this.mInputBuffer;
            n3 = this.mInputStart;
            n2 = n3 + this.mInputLen;
        } else {
            cArray = this.getTextBuffer();
            n3 = 0;
            n2 = this.mSegmentSize + this.mCurrentSize;
        }
        while (true) {
            if (n3 >= n2) {
                typedValueDecoder.handleEmptyValue();
                return;
            }
            if (!StringUtil.isSpace(cArray[n3])) break;
            ++n3;
        }
        while (--n2 > n3 && StringUtil.isSpace(cArray[n2])) {
        }
        typedValueDecoder.decode(cArray, n3, n2 + 1);
    }

    public int decodeElements(TypedArrayDecoder typedArrayDecoder, InputProblemReporter inputProblemReporter) throws TypedXMLStreamException {
        int n2;
        block11: {
            n2 = 0;
            if (this.mInputStart < 0) {
                if (this.mHasSegments) {
                    this.mInputBuffer = this.buildResultArray();
                    this.mInputLen = this.mInputBuffer.length;
                    this.clearSegments();
                } else {
                    this.mInputBuffer = this.mCurrentSegment;
                    this.mInputLen = this.mCurrentSize;
                }
                this.mInputStart = 0;
            }
            int n3 = this.mInputStart;
            int n4 = n3 + this.mInputLen;
            char[] cArray = this.mInputBuffer;
            int n5 = n3;
            try {
                while (n3 < n4) {
                    int n6;
                    while (cArray[n3] <= ' ') {
                        if (++n3 < n4) continue;
                        break block11;
                    }
                    n5 = n3++;
                    while (n3 < n4 && cArray[n3] > ' ') {
                        ++n3;
                    }
                    ++n2;
                    if (!typedArrayDecoder.decodeValue(cArray, n5, n6 = n3++)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Location location = inputProblemReporter.getLocation();
                String string = new String(cArray, n5, n3 - n5 - 1);
                throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), location, illegalArgumentException);
            }
            finally {
                this.mInputStart = n3;
                this.mInputLen = n4 - n3;
            }
        }
        return n2;
    }

    public void initBinaryChunks(Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, boolean bl2) {
        if (this.mInputStart < 0) {
            charArrayBase64Decoder.init(base64Variant, bl2, this.mCurrentSegment, 0, this.mCurrentSize, this.mSegments);
        } else {
            charArrayBase64Decoder.init(base64Variant, bl2, this.mInputBuffer, this.mInputStart, this.mInputLen, null);
        }
    }

    public String contentsAsString() {
        if (this.mResultString == null) {
            if (this.mResultArray != null) {
                this.mResultString = new String(this.mResultArray);
            } else if (this.mInputStart >= 0) {
                if (this.mInputLen < 1) {
                    this.mResultString = "";
                    return "";
                }
                this.mResultString = new String(this.mInputBuffer, this.mInputStart, this.mInputLen);
            } else {
                int n2 = this.mSegmentSize;
                int n3 = this.mCurrentSize;
                if (n2 == 0) {
                    this.mResultString = n3 == 0 ? "" : new String(this.mCurrentSegment, 0, n3);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n2 + n3);
                    if (this.mSegments != null) {
                        int n4 = this.mSegments.size();
                        for (int i2 = 0; i2 < n4; ++i2) {
                            char[] cArray = this.mSegments.get(i2);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this.mCurrentSegment, 0, this.mCurrentSize);
                    this.mResultString = stringBuilder.toString();
                }
            }
        }
        return this.mResultString;
    }

    public StringBuilder contentsAsStringBuilder(int n2) {
        if (this.mResultString != null) {
            return new StringBuilder(this.mResultString);
        }
        if (this.mResultArray != null) {
            StringBuilder stringBuilder = new StringBuilder(this.mResultArray.length + n2);
            stringBuilder.append(this.mResultArray, 0, this.mResultArray.length);
            return stringBuilder;
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen < 1) {
                return new StringBuilder();
            }
            StringBuilder stringBuilder = new StringBuilder(this.mInputLen + n2);
            stringBuilder.append(this.mInputBuffer, this.mInputStart, this.mInputLen);
            return stringBuilder;
        }
        int n3 = this.mSegmentSize;
        int n4 = this.mCurrentSize;
        StringBuilder stringBuilder = new StringBuilder(n3 + n4 + n2);
        if (this.mSegments != null) {
            int n5 = this.mSegments.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                char[] cArray = this.mSegments.get(i2);
                stringBuilder.append(cArray, 0, cArray.length);
            }
        }
        stringBuilder.append(this.mCurrentSegment, 0, n4);
        return stringBuilder;
    }

    public void contentsToStringBuilder(StringBuilder stringBuilder) {
        if (this.mResultString != null) {
            stringBuilder.append(this.mResultString);
        } else if (this.mResultArray != null) {
            stringBuilder.append(this.mResultArray);
        } else if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                stringBuilder.append(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
        } else {
            if (this.mSegments != null) {
                int n2 = this.mSegments.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char[] cArray = this.mSegments.get(i2);
                    stringBuilder.append(cArray, 0, cArray.length);
                }
            }
            stringBuilder.append(this.mCurrentSegment, 0, this.mCurrentSize);
        }
    }

    public char[] contentsAsArray() {
        char[] cArray = this.mResultArray;
        if (cArray == null) {
            this.mResultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public int contentsToArray(int n2, char[] cArray, int n3, int n4) {
        int n5;
        if (this.mInputStart >= 0) {
            int n6 = this.mInputLen - n2;
            if (n6 > n4) {
                n6 = n4;
            } else if (n6 < 0) {
                n6 = 0;
            }
            if (n6 > 0) {
                System.arraycopy(this.mInputBuffer, this.mInputStart + n2, cArray, n3, n6);
            }
            return n6;
        }
        int n7 = 0;
        if (this.mSegments != null) {
            int n8 = this.mSegments.size();
            for (n5 = 0; n5 < n8; ++n5) {
                char[] cArray2 = this.mSegments.get(n5);
                int n9 = cArray2.length;
                int n10 = n9 - n2;
                if (n10 < 1) {
                    n2 -= n9;
                    continue;
                }
                if (n10 >= n4) {
                    System.arraycopy(cArray2, n2, cArray, n3, n4);
                    return n7 + n4;
                }
                System.arraycopy(cArray2, n2, cArray, n3, n10);
                n7 += n10;
                n3 += n10;
                n4 -= n10;
                n2 = 0;
            }
        }
        if (n4 > 0) {
            n5 = this.mCurrentSize - n2;
            if (n4 > n5) {
                n4 = n5;
            }
            if (n4 > 0) {
                System.arraycopy(this.mCurrentSegment, n2, cArray, n3, n4);
                n7 += n4;
            }
        }
        return n7;
    }

    public int rawContentsTo(Writer writer) throws IOException {
        if (this.mResultArray != null) {
            writer.write(this.mResultArray);
            return this.mResultArray.length;
        }
        if (this.mResultString != null) {
            writer.write(this.mResultString);
            return this.mResultString.length();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                writer.write(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return this.mInputLen;
        }
        int n2 = 0;
        if (this.mSegments != null) {
            int n3 = this.mSegments.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                char[] cArray = this.mSegments.get(i2);
                writer.write(cArray);
                n2 += cArray.length;
            }
        }
        if (this.mCurrentSize > 0) {
            writer.write(this.mCurrentSegment, 0, this.mCurrentSize);
            n2 += this.mCurrentSize;
        }
        return n2;
    }

    @Deprecated
    public Reader rawContentsViaReader() throws IOException {
        if (this.mResultArray != null) {
            return new CharArrayReader(this.mResultArray);
        }
        if (this.mResultString != null) {
            return new StringReader(this.mResultString);
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                return new CharArrayReader(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return new StringReader("");
        }
        if (this.mSegments == null || this.mSegments.size() == 0) {
            return new CharArrayReader(this.mCurrentSegment, 0, this.mCurrentSize);
        }
        return new BufferReader(this.mSegments, this.mCurrentSegment, this.mCurrentSize);
    }

    public boolean isAllWhitespace() {
        int n2;
        if (this.mInputStart >= 0) {
            int n3;
            char[] cArray = this.mInputBuffer;
            int n4 = n3 + this.mInputLen;
            for (n3 = this.mInputStart; n3 < n4; ++n3) {
                if (cArray[n3] <= ' ') continue;
                return false;
            }
            return true;
        }
        if (this.mSegments != null) {
            n2 = this.mSegments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                char[] cArray = this.mSegments.get(i2);
                int n5 = cArray.length;
                for (int i3 = 0; i3 < n5; ++i3) {
                    if (cArray[i3] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] cArray = this.mCurrentSegment;
        int n6 = this.mCurrentSize;
        for (n2 = 0; n2 < n6; ++n2) {
            if (cArray[n2] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean equalsString(String string) {
        int n2 = string.length();
        if (this.mInputStart >= 0) {
            if (this.mInputLen != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (string.charAt(i2) == this.mInputBuffer[this.mInputStart + i2]) continue;
                return false;
            }
            return true;
        }
        if (n2 != this.size()) {
            return false;
        }
        char[] cArray = this.mSegments == null || this.mSegments.size() == 0 ? this.mCurrentSegment : this.contentsAsArray();
        for (int i3 = 0; i3 < n2; ++i3) {
            if (cArray[i3] == string.charAt(i3)) continue;
            return false;
        }
        return true;
    }

    public void fireSaxCharacterEvents(ContentHandler contentHandler) throws SAXException {
        if (this.mResultArray != null) {
            contentHandler.characters(this.mResultArray, 0, this.mResultArray.length);
        } else if (this.mInputStart >= 0) {
            contentHandler.characters(this.mInputBuffer, this.mInputStart, this.mInputLen);
        } else {
            if (this.mSegments != null) {
                int n2 = this.mSegments.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char[] cArray = this.mSegments.get(i2);
                    contentHandler.characters(cArray, 0, cArray.length);
                }
            }
            if (this.mCurrentSize > 0) {
                contentHandler.characters(this.mCurrentSegment, 0, this.mCurrentSize);
            }
        }
    }

    public void fireSaxSpaceEvents(ContentHandler contentHandler) throws SAXException {
        if (this.mResultArray != null) {
            contentHandler.ignorableWhitespace(this.mResultArray, 0, this.mResultArray.length);
        } else if (this.mInputStart >= 0) {
            contentHandler.ignorableWhitespace(this.mInputBuffer, this.mInputStart, this.mInputLen);
        } else {
            if (this.mSegments != null) {
                int n2 = this.mSegments.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char[] cArray = this.mSegments.get(i2);
                    contentHandler.ignorableWhitespace(cArray, 0, cArray.length);
                }
            }
            if (this.mCurrentSize > 0) {
                contentHandler.ignorableWhitespace(this.mCurrentSegment, 0, this.mCurrentSize);
            }
        }
    }

    public void fireSaxCommentEvent(LexicalHandler lexicalHandler) throws SAXException {
        if (this.mResultArray != null) {
            lexicalHandler.comment(this.mResultArray, 0, this.mResultArray.length);
        } else if (this.mInputStart >= 0) {
            lexicalHandler.comment(this.mInputBuffer, this.mInputStart, this.mInputLen);
        } else if (this.mSegments != null && this.mSegments.size() > 0) {
            char[] cArray = this.contentsAsArray();
            lexicalHandler.comment(cArray, 0, cArray.length);
        } else {
            lexicalHandler.comment(this.mCurrentSegment, 0, this.mCurrentSize);
        }
    }

    public void fireDtdCommentEvent(DTDEventListener dTDEventListener) {
        if (this.mResultArray != null) {
            dTDEventListener.dtdComment(this.mResultArray, 0, this.mResultArray.length);
        } else if (this.mInputStart >= 0) {
            dTDEventListener.dtdComment(this.mInputBuffer, this.mInputStart, this.mInputLen);
        } else if (this.mSegments != null && this.mSegments.size() > 0) {
            char[] cArray = this.contentsAsArray();
            dTDEventListener.dtdComment(cArray, 0, cArray.length);
        } else {
            dTDEventListener.dtdComment(this.mCurrentSegment, 0, this.mCurrentSize);
        }
    }

    public void validateText(XMLValidator xMLValidator, boolean bl2) throws XMLStreamException {
        if (this.mInputStart >= 0) {
            xMLValidator.validateText(this.mInputBuffer, this.mInputStart, this.mInputStart + this.mInputLen, bl2);
        } else {
            xMLValidator.validateText(this.contentsAsString(), bl2);
        }
    }

    public void ensureNotShared() {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
    }

    public void append(char c2) {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] cArray = this.mCurrentSegment;
        if (this.mCurrentSize >= cArray.length) {
            this.expand(1);
            cArray = this.mCurrentSegment;
        }
        cArray[this.mCurrentSize++] = c2;
    }

    public void append(char[] cArray, int n2, int n3) {
        if (this.mInputStart >= 0) {
            this.unshare(n3);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] cArray2 = this.mCurrentSegment;
        int n4 = cArray2.length - this.mCurrentSize;
        if (n4 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this.mCurrentSize, n3);
            this.mCurrentSize += n3;
        } else {
            if (n4 > 0) {
                System.arraycopy(cArray, n2, cArray2, this.mCurrentSize, n4);
                n2 += n4;
                n3 -= n4;
            }
            this.expand(n3);
            System.arraycopy(cArray, n2, this.mCurrentSegment, 0, n3);
            this.mCurrentSize = n3;
        }
    }

    public void append(String string) {
        int n2 = string.length();
        if (this.mInputStart >= 0) {
            this.unshare(n2);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] cArray = this.mCurrentSegment;
        int n3 = cArray.length - this.mCurrentSize;
        if (n3 >= n2) {
            string.getChars(0, n2, cArray, this.mCurrentSize);
            this.mCurrentSize += n2;
        } else {
            if (n3 > 0) {
                string.getChars(0, n3, cArray, this.mCurrentSize);
                n2 -= n3;
            }
            this.expand(n2);
            string.getChars(n3, n3 + n2, this.mCurrentSegment, 0);
            this.mCurrentSize = n2;
        }
    }

    public char[] getCurrentSegment() {
        if (this.mInputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this.mCurrentSegment;
            if (cArray == null) {
                this.mCurrentSegment = this.allocBuffer(0);
            } else if (this.mCurrentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this.mCurrentSegment;
    }

    public int getCurrentSegmentSize() {
        return this.mCurrentSize;
    }

    public void setCurrentLength(int n2) {
        this.mCurrentSize = n2;
    }

    public char[] finishCurrentSegment() {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        this.mHasSegments = true;
        this.mSegments.add(this.mCurrentSegment);
        int n2 = this.mCurrentSegment.length;
        this.mSegmentSize += n2;
        char[] cArray = new char[this.calcNewSize(n2)];
        this.mCurrentSize = 0;
        this.mCurrentSegment = cArray;
        return cArray;
    }

    private int calcNewSize(int n2) {
        int n3 = n2 < 8000 ? n2 : n2 >> 1;
        int n4 = n2 + n3;
        return Math.min(n4, 262144);
    }

    public String toString() {
        return this.contentsAsString();
    }

    public void unshare(int n2) {
        int n3 = this.mInputLen;
        this.mInputLen = 0;
        char[] cArray = this.mInputBuffer;
        this.mInputBuffer = null;
        int n4 = this.mInputStart;
        this.mInputStart = -1;
        int n5 = n3 + n2;
        if (this.mCurrentSegment == null || n5 > this.mCurrentSegment.length) {
            this.mCurrentSegment = this.allocBuffer(n5);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this.mCurrentSegment, 0, n3);
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = n3;
    }

    private void expand(int n2) {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        char[] cArray = this.mCurrentSegment;
        this.mHasSegments = true;
        this.mSegments.add(cArray);
        int n3 = cArray.length;
        this.mSegmentSize += n3;
        int n4 = Math.max(n2, this.calcNewSize(n3));
        cArray = new char[n4];
        this.mCurrentSize = 0;
        this.mCurrentSegment = cArray;
    }

    private char[] buildResultArray() {
        char[] cArray;
        if (this.mResultString != null) {
            return this.mResultString.toCharArray();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen < 1) {
                return DataUtil.getEmptyCharArray();
            }
            cArray = new char[this.mInputLen];
            System.arraycopy(this.mInputBuffer, this.mInputStart, cArray, 0, this.mInputLen);
        } else {
            int n2 = this.size();
            if (n2 < 1) {
                return DataUtil.getEmptyCharArray();
            }
            int n3 = 0;
            cArray = new char[n2];
            if (this.mSegments != null) {
                int n4 = this.mSegments.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    char[] cArray2 = this.mSegments.get(i2);
                    int n5 = cArray2.length;
                    System.arraycopy(cArray2, 0, cArray, n3, n5);
                    n3 += n5;
                }
            }
            System.arraycopy(this.mCurrentSegment, 0, cArray, n3, this.mCurrentSize);
        }
        return cArray;
    }

    private static final class BufferReader
    extends Reader {
        ArrayList<char[]> _segments;
        char[] _currentSegment;
        final int _currentLength;
        int _segmentIndex;
        int _segmentOffset;
        int _currentOffset;

        public BufferReader(ArrayList<char[]> arrayList, char[] cArray, int n2) {
            this._segments = arrayList;
            this._currentSegment = cArray;
            this._currentLength = n2;
            this._segmentIndex = 0;
            this._currentOffset = 0;
            this._segmentOffset = 0;
        }

        @Override
        public void close() {
            this._segments = null;
            this._currentSegment = null;
        }

        @Override
        public void mark(int n2) throws IOException {
            throw new IOException("mark() not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) {
            if (n3 < 1) {
                return 0;
            }
            int n4 = n2;
            while (this._segments != null) {
                char[] cArray2 = this._segments.get(this._segmentIndex);
                int n5 = cArray2.length - this._segmentOffset;
                if (n3 <= n5) {
                    System.arraycopy(cArray2, this._segmentOffset, cArray, n2, n3);
                    this._segmentOffset += n3;
                    return (n2 += n3) - n4;
                }
                if (n5 > 0) {
                    System.arraycopy(cArray2, this._segmentOffset, cArray, n2, n5);
                    n2 += n5;
                    n3 -= n5;
                }
                if (++this._segmentIndex >= this._segments.size()) {
                    this._segments = null;
                    continue;
                }
                this._segmentOffset = 0;
            }
            if (n3 > 0 && this._currentSegment != null) {
                int n6 = this._currentLength - this._currentOffset;
                if (n3 >= n6) {
                    n3 = n6;
                    System.arraycopy(this._currentSegment, this._currentOffset, cArray, n2, n3);
                    this._currentSegment = null;
                } else {
                    System.arraycopy(this._currentSegment, this._currentOffset, cArray, n2, n3);
                    this._currentOffset += n3;
                }
                n2 += n3;
            }
            return n4 == n2 ? -1 : n2 - n4;
        }

        @Override
        public boolean ready() {
            return true;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("reset() not supported");
        }

        @Override
        public long skip(long l2) {
            if (l2 < 0L) {
                return 0L;
            }
            long l3 = l2;
            while (this._segments != null) {
                char[] cArray = this._segments.get(this._segmentIndex);
                int n2 = cArray.length - this._segmentOffset;
                if ((long)n2 >= l2) {
                    this._segmentOffset += (int)l2;
                    return l3;
                }
                l2 -= (long)n2;
                if (++this._segmentIndex >= this._segments.size()) {
                    this._segments = null;
                    continue;
                }
                this._segmentOffset = 0;
            }
            if (l2 > 0L && this._currentSegment != null) {
                int n3 = this._currentLength - this._currentOffset;
                if (l2 >= (long)n3) {
                    l2 -= (long)n3;
                    this._currentSegment = null;
                } else {
                    l2 = 0L;
                    this._currentOffset += (int)l2;
                }
            }
            return l2 == l3 ? -1L : l3 - l2;
        }
    }
}

