/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.evt;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BaseNsContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Namespace;

public class MergedNsContext
extends BaseNsContext {
    final NamespaceContext mParentCtxt;
    final List<Namespace> mNamespaces;
    Map<String, Namespace> mNsByPrefix = null;
    Map<String, Namespace> mNsByURI = null;

    protected MergedNsContext(NamespaceContext namespaceContext, List<Namespace> list) {
        this.mParentCtxt = namespaceContext;
        this.mNamespaces = list == null ? Collections.emptyList() : list;
    }

    public static BaseNsContext construct(NamespaceContext namespaceContext, List<Namespace> list) {
        return new MergedNsContext(namespaceContext, list);
    }

    @Override
    public String doGetNamespaceURI(String string) {
        Namespace namespace;
        if (this.mNsByPrefix == null) {
            this.mNsByPrefix = this.buildByPrefixMap();
        }
        if ((namespace = this.mNsByPrefix.get(string)) == null && this.mParentCtxt != null) {
            return this.mParentCtxt.getNamespaceURI(string);
        }
        return namespace == null ? null : namespace.getNamespaceURI();
    }

    @Override
    public String doGetPrefix(String string) {
        Namespace namespace;
        if (this.mNsByURI == null) {
            this.mNsByURI = this.buildByNsURIMap();
        }
        if ((namespace = this.mNsByURI.get(string)) == null && this.mParentCtxt != null) {
            return this.mParentCtxt.getPrefix(string);
        }
        return namespace == null ? null : namespace.getPrefix();
    }

    @Override
    public Iterator<String> doGetPrefixes(String string) {
        ArrayList<String> arrayList = null;
        int n2 = this.mNamespaces.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2;
            Namespace namespace = this.mNamespaces.get(i2);
            String string3 = namespace.getNamespaceURI();
            if (string3 == null) {
                string3 = "";
            }
            if (!string3.equals(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add((string2 = namespace.getPrefix()) == null ? "" : string2);
        }
        if (this.mParentCtxt != null) {
            Iterator<String> iterator = this.mParentCtxt.getPrefixes(string);
            if (arrayList == null) {
                return iterator;
            }
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (arrayList == null) {
            return DataUtil.emptyIterator();
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        return this.mNamespaces.iterator();
    }

    @Override
    public void outputNamespaceDeclarations(Writer writer) throws IOException {
        int n2 = this.mNamespaces.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Namespace namespace = this.mNamespaces.get(i2);
            writer.write(32);
            writer.write("xmlns");
            if (!namespace.isDefaultNamespaceDeclaration()) {
                writer.write(58);
                writer.write(namespace.getPrefix());
            }
            writer.write("=\"");
            writer.write(namespace.getNamespaceURI());
            writer.write(34);
        }
    }

    @Override
    public void outputNamespaceDeclarations(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        int n2 = this.mNamespaces.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Namespace namespace = this.mNamespaces.get(i2);
            if (namespace.isDefaultNamespaceDeclaration()) {
                xMLStreamWriter.writeDefaultNamespace(namespace.getNamespaceURI());
                continue;
            }
            xMLStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    private Map<String, Namespace> buildByPrefixMap() {
        int n2 = this.mNamespaces.size();
        if (n2 == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Namespace> linkedHashMap = new LinkedHashMap<String, Namespace>(1 + n2 + (n2 >> 1));
        for (int i2 = 0; i2 < n2; ++i2) {
            Namespace namespace = this.mNamespaces.get(i2);
            String string = namespace.getPrefix();
            if (string == null) {
                string = "";
            }
            linkedHashMap.put(string, namespace);
        }
        return linkedHashMap;
    }

    private Map<String, Namespace> buildByNsURIMap() {
        int n2 = this.mNamespaces.size();
        if (n2 == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Namespace> linkedHashMap = new LinkedHashMap<String, Namespace>(1 + n2 + (n2 >> 1));
        for (int i2 = 0; i2 < n2; ++i2) {
            Namespace namespace = this.mNamespaces.get(i2);
            String string = namespace.getNamespaceURI();
            if (string == null) {
                string = "";
            }
            linkedHashMap.put(string, namespace);
        }
        return linkedHashMap;
    }
}

