/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.util;

import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import hudson.plugins.gradle.Gradle;
import hudson.tasks.Builder;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class RunUtil {
    private RunUtil() {
    }

    public static <T extends Actionable, A extends Action> A getOrCreateAction(T actionable, Class<A> actionClass, Supplier<A> actionFactory) {
        Action action = actionable.getAction(actionClass);
        if (action == null) {
            action = (Action)actionFactory.get();
            actionable.addAction(action);
        }
        return (A)action;
    }

    public static boolean isFreestyleBuildWithGradle(@Nullable Run<?, ?> build) {
        if (build == null) {
            return false;
        }
        if (build instanceof FreeStyleBuild) {
            for (Builder builder : ((FreeStyleProject)((FreeStyleBuild)build).getProject()).getBuildersList()) {
                if (!(builder instanceof Gradle)) continue;
                return true;
            }
        }
        return false;
    }
}

