/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.FilePath;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenCoordinates;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenExtensions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenExtensionsDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenExtensionsDetector.class);

    static Set<MavenExtension> detect(InjectionConfig config, FilePath workspace) throws IOException, InterruptedException {
        if (InjectionUtil.isInvalid(InjectionConfig.checkRequiredVersion(config.getMavenExtensionVersion()))) {
            return Collections.emptySet();
        }
        FilePath extensionsFile = workspace.child(".mvn/extensions.xml");
        if (extensionsFile.exists()) {
            LOGGER.debug("Found extensions file: {}", (Object)extensionsFile);
            MavenExtensions mavenExtensions = MavenExtensions.fromFilePath(extensionsFile);
            HashSet<MavenExtension> knownExtensions = new HashSet<MavenExtension>();
            if (mavenExtensions.hasExtension(MavenExtension.DEVELOCITY.getCoordinates()) || mavenExtensions.hasExtension(MavenExtension.GRADLE_ENTERPRISE.getCoordinates()) || mavenExtensions.hasExtension(MavenCoordinates.parseCoordinates(config.getMavenExtensionCustomCoordinates()))) {
                knownExtensions.add(MavenExtension.DEVELOCITY);
                knownExtensions.add(MavenExtension.GRADLE_ENTERPRISE);
            }
            if (mavenExtensions.hasExtension(MavenExtension.CCUD.getCoordinates()) || mavenExtensions.hasExtension(MavenCoordinates.parseCoordinates(config.getCcudExtensionCustomCoordinates()))) {
                knownExtensions.add(MavenExtension.CCUD);
            }
            return knownExtensions;
        }
        LOGGER.debug("Extensions file not found: {}", (Object)extensionsFile);
        return Collections.emptySet();
    }
}

