/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.FilePath;
import hudson.plugins.gradle.injection.MavenCoordinates;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class MavenExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenExtensions.class);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String EXTENSION_XPATH_EXPR = "/extensions/extension[groupId = '%s' and artifactId = '%s']";
    private final Document document;

    private MavenExtensions(Document document) {
        this.document = document;
    }

    static MavenExtensions empty() {
        return new MavenExtensions(null);
    }

    static MavenExtensions fromFilePath(FilePath extensionsFile) {
        MavenExtensions mavenExtensions;
        block8: {
            InputStream inputStream = extensionsFile.read();
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                document.normalizeDocument();
                mavenExtensions = new MavenExtensions(document);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException | ParserConfigurationException | SAXException e) {
                    LOGGER.warn("Failed to parse extensions file: {}", (Object)extensionsFile, (Object)e);
                    return MavenExtensions.empty();
                }
            }
            inputStream.close();
        }
        return mavenExtensions;
    }

    boolean hasExtension(MavenCoordinates coordinates) {
        if (this.document == null || coordinates == null) {
            return false;
        }
        String expr = String.format(EXTENSION_XPATH_EXPR, coordinates.groupId(), coordinates.artifactId());
        try {
            XPathExpression exprCompiled = XPATH.compile(expr);
            NodeList extension = (NodeList)exprCompiled.evaluate(this.document, XPathConstants.NODESET);
            return extension != null && extension.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Could not apply XPath expression: {}", (Object)expr, (Object)e);
            return false;
        }
    }
}

