/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.Util;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenCoordinates;
import java.net.URI;
import javax.annotation.Nullable;

public enum MavenExtension {
    DEVELOCITY("develocity-maven-extension", "develocity_metadata", new MavenCoordinates("com.gradle", "develocity-maven-extension")),
    GRADLE_ENTERPRISE("gradle-enterprise-maven-extension", "develocity_metadata", new MavenCoordinates("com.gradle", "gradle-enterprise-maven-extension")),
    CCUD("common-custom-user-data-maven-extension", "ccud_metadata", new MavenCoordinates("com.gradle", "common-custom-user-data-maven-extension")),
    CONFIGURATION("configuration-maven-extension", "configuration_metadata", new MavenCoordinates("com.gradle", "configuration-maven-extension"));

    private static final String EXTENSION_REPOSITORY_PATH = "/com/gradle/%s/%s/%s-%s.jar";
    private static final String DEFAULT_REPOSITORY_URL = "https://repo1.maven.org/maven2";
    private static final String JAR_EXTENSION = ".jar";
    private static final String LAST_GRADLE_ENTERPRISE_VERSION = "1.20.1";
    private final String name;
    private final String downloadMetadataFileName;
    private final MavenCoordinates coordinates;

    private MavenExtension(String name, String downloadMetadataFileName, MavenCoordinates coordinates) {
        this.name = name;
        this.downloadMetadataFileName = downloadMetadataFileName;
        this.coordinates = coordinates;
    }

    public String getTargetJarName() {
        return this.name + JAR_EXTENSION;
    }

    public String getEmbeddedJarName() {
        return this.name + JAR_EXTENSION;
    }

    public MavenCoordinates getCoordinates() {
        return this.coordinates;
    }

    public String getName() {
        return this.name;
    }

    public String getDownloadMetadataFileName() {
        return this.downloadMetadataFileName;
    }

    public static MavenExtension getDevelocityMavenExtension(String version) {
        return version.compareTo(LAST_GRADLE_ENTERPRISE_VERSION) > 0 ? DEVELOCITY : GRADLE_ENTERPRISE;
    }

    public URI createDownloadUrl(String version, @Nullable String repositoryUrl) {
        String extensionUrlTemplate = this.getNormalizedRepositoryUrl(repositoryUrl) + EXTENSION_REPOSITORY_PATH;
        return URI.create(String.format(extensionUrlTemplate, this.getName(), version, this.getName(), version));
    }

    private String getNormalizedRepositoryUrl(@Nullable String repositoryUrl) {
        if (repositoryUrl == null || InjectionUtil.isInvalid(InjectionConfig.checkUrl(repositoryUrl))) {
            return DEFAULT_REPOSITORY_URL;
        }
        return Util.removeTrailingSlash((String)repositoryUrl);
    }

    public static final class RepositoryCredentials {
        private final String username;
        private final String password;

        public RepositoryCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }
    }
}

