/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import java.io.Serializable;
import java.util.Objects;

public final class MavenCoordinates
implements Serializable {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public MavenCoordinates(String groupId, String artifactId) {
        this(groupId, artifactId, "unspecified");
    }

    public MavenCoordinates(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinates that = (MavenCoordinates)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    static MavenCoordinates parseCoordinates(String groupAndArtifact) {
        if (groupAndArtifact == null || groupAndArtifact.trim().isEmpty()) {
            return null;
        }
        String[] ga = groupAndArtifact.split(":");
        if (ga.length == 2) {
            return new MavenCoordinates(ga[0], ga[1]);
        }
        if (ga.length == 3) {
            return new MavenCoordinates(ga[0], ga[1], ga[2]);
        }
        return null;
    }

    static boolean isValid(String value) {
        return MavenCoordinates.parseCoordinates(value) != null;
    }

    String groupId() {
        return this.groupId;
    }

    String artifactId() {
        return this.artifactId;
    }

    String version() {
        return this.version;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }
}

