/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.FilePath;
import hudson.model.Node;
import hudson.plugins.gradle.injection.EnvUtil;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenExtClasspathUtils;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenExtensionsHandler;
import hudson.plugins.gradle.injection.MavenInjectionAware;
import hudson.plugins.gradle.injection.SystemProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class MavenBuildScanInjection
implements MavenInjectionAware {
    private static final Logger LOGGER = Logger.getLogger(MavenBuildScanInjection.class.getName());
    public static final String JENKINSGRADLEPLUGIN_MAVEN_AUTO_INJECTION = "JENKINSGRADLEPLUGIN_MAVEN_AUTO_INJECTION";
    private static final List<String> ALL_INJECTED_ENVIRONMENT_VARIABLES = Arrays.asList("JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_EXT_CLASSPATH", "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_SERVER_URL", "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_ALLOW_UNTRUSTED_SERVER", "JENKINSGRADLEPLUGIN_MAVEN_AUTO_INJECTION");
    private final MavenExtensionsHandler extensionsHandler = new MavenExtensionsHandler();

    public void inject(Node node, Map<MavenExtension, String> extensionsDigest) {
        block8: {
            if (node == null) {
                return;
            }
            FilePath nodeRootPath = node.getRootPath();
            if (nodeRootPath == null) {
                return;
            }
            InjectionConfig config = InjectionConfig.get();
            boolean enabled = this.isInjectionEnabledForNode(config, node);
            try {
                if (enabled) {
                    if (!extensionsDigest.isEmpty()) {
                        this.inject(config, node, nodeRootPath, extensionsDigest);
                    } else {
                        LOGGER.log(Level.WARNING, "Extension digests are not present even though injection is enabled");
                    }
                } else {
                    this.cleanup(node, nodeRootPath);
                }
            }
            catch (IllegalStateException e) {
                if (!enabled) break block8;
                LOGGER.log(Level.WARNING, "Unexpected exception while injecting build scans for Maven", e);
            }
        }
    }

    private void inject(InjectionConfig config, Node node, FilePath nodeRootPath, Map<MavenExtension, String> extensionsDigest) {
        try {
            EnvUtil.setEnvVar(node, JENKINSGRADLEPLUGIN_MAVEN_AUTO_INJECTION, "true");
            String server = config.getServer();
            LOGGER.info("Injecting Maven extensions " + String.valueOf(nodeRootPath));
            ArrayList<FilePath> extensions = new ArrayList<FilePath>();
            FilePath controllerRootPath = Jenkins.get().getRootPath();
            MavenExtension develocityMavenExtension = MavenExtension.getDevelocityMavenExtension(config.getMavenExtensionVersion());
            extensions.add(this.extensionsHandler.copyExtensionToAgent(develocityMavenExtension, controllerRootPath, nodeRootPath, extensionsDigest.get((Object)develocityMavenExtension)));
            if (InjectionUtil.isInvalid(InjectionConfig.checkRequiredVersion(config.getCcudExtensionVersion()))) {
                this.extensionsHandler.deleteExtensionFromAgent(MavenExtension.CCUD, nodeRootPath);
            } else {
                extensions.add(this.extensionsHandler.copyExtensionToAgent(MavenExtension.CCUD, controllerRootPath, nodeRootPath, extensionsDigest.get((Object)MavenExtension.CCUD)));
            }
            boolean isUnix = MavenExtClasspathUtils.isUnix(node);
            ArrayList<SystemProperty> systemProperties = new ArrayList<SystemProperty>();
            systemProperties.add(new SystemProperty(MAVEN_EXT_CLASS_PATH_PROPERTY_KEY, MavenExtClasspathUtils.constructExtClasspath(extensions, isUnix)));
            systemProperties.add(new SystemProperty(DEVELOCITY_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, "false"));
            systemProperties.add(new SystemProperty(BUILD_SCAN_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, "false"));
            systemProperties.add(new SystemProperty(DEVELOCITY_URL_PROPERTY_KEY, server));
            systemProperties.add(new SystemProperty(GRADLE_ENTERPRISE_URL_PROPERTY_KEY, server));
            if (config.isAllowUntrusted()) {
                systemProperties.add(new SystemProperty(DEVELOCITY_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, "true"));
                systemProperties.add(new SystemProperty(GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, "true"));
            }
            String captureFileFingerprints = Optional.ofNullable(config.isMavenCaptureGoalInputFiles()).map(b -> Boolean.toString(b)).orElse("true");
            systemProperties.add(new SystemProperty(DEVELOCITY_CAPTURE_FILE_FINGERPRINTS_PROPERTY_KEY, captureFileFingerprints));
            systemProperties.add(new SystemProperty(GRADLE_ENTERPRISE_CAPTURE_GOAL_INPUT_FILES_PROPERTY_KEY, captureFileFingerprints));
            systemProperties.add(new SystemProperty(DEVELOCITY_CUSTOM_VALUE_KEY, "Jenkins"));
            EnvUtil.setEnvVar(node, "MAVEN_OPTS", MAVEN_OPTS_HANDLER.merge(node, systemProperties));
            extensions.add(this.extensionsHandler.copyExtensionToAgent(MavenExtension.CONFIGURATION, nodeRootPath));
            EnvUtil.setEnvVar(node, "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_EXT_CLASSPATH", MavenExtClasspathUtils.constructExtClasspath(extensions, isUnix));
            EnvUtil.setEnvVar(node, "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_SERVER_URL", config.getServer());
            if (config.isAllowUntrusted()) {
                EnvUtil.setEnvVar(node, "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_ALLOW_UNTRUSTED_SERVER", "true");
            } else {
                EnvUtil.removeEnvVar(node, "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_ALLOW_UNTRUSTED_SERVER");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private void cleanup(Node node, FilePath rootPath) {
        try {
            this.extensionsHandler.deleteAllExtensionsFromAgent(rootPath);
            MAVEN_OPTS_HANDLER.removeIfNeeded(node);
            EnvUtil.removeEnvVars(node, ALL_INJECTED_ENVIRONMENT_VARIABLES);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

