/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.EnvironmentContributingAction;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.gradle.injection.InitScriptVariables;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenExtClasspathUtils;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenExtensionsDetector;
import hudson.plugins.gradle.injection.MavenInjectionAware;
import hudson.plugins.gradle.injection.MavenOptsDevelocityFilter;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitScmListener
extends SCMListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitScmListener.class);

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
        try {
            InjectionConfig config = InjectionConfig.get();
            if (GitScmListener.isInjectionGloballyDisabled(config)) {
                return;
            }
            if (!GitScmListener.isInjectionEnabledForRepository(config, scm)) {
                GitScmListener.disableAutoInjection(build, workspace, config, listener);
                return;
            }
            GitScmListener.disableMavenAutoInjectionIfAlreadyApplied(build, workspace, config, listener);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when processing onCheckout notification", (Throwable)e);
        }
    }

    private static void disableAutoInjection(Run<?, ?> build, FilePath workspace, InjectionConfig config, TaskListener listener) throws Exception {
        String currentMavenOpts;
        Computer computer = workspace.toComputer();
        if (computer == null) {
            return;
        }
        EnvVars envVars = computer.buildEnvironment(listener);
        if (GitScmListener.shouldDisableGradleInjection(config)) {
            build.addAction((Action)GradleInjectionDisabledAction.INSTANCE);
        }
        if (GitScmListener.shouldDisableMavenInjection(config) && (currentMavenOpts = (String)envVars.get((Object)"MAVEN_OPTS")) != null) {
            String mavenOpts = Strings.nullToEmpty((String)MavenInjectionAware.MAVEN_OPTS_HANDLER.removeIfNeeded(currentMavenOpts));
            build.addAction((Action)new MavenInjectionDisabledAction(mavenOpts));
        }
    }

    private static void disableMavenAutoInjectionIfAlreadyApplied(Run<?, ?> build, FilePath workspace, InjectionConfig config, TaskListener listener) throws Exception {
        Set<MavenExtension> knownExtensions;
        Computer computer = workspace.toComputer();
        if (computer == null) {
            return;
        }
        EnvVars envVars = computer.buildEnvironment(listener);
        String currentMavenOpts = (String)envVars.get((Object)"MAVEN_OPTS");
        if (currentMavenOpts != null && !(knownExtensions = MavenExtensionsDetector.detect(config, workspace)).isEmpty()) {
            build.addAction((Action)new MavenInjectionDisabledAction(new MavenOptsDevelocityFilter(knownExtensions, MavenExtClasspathUtils.isUnix(computer)).filter(currentMavenOpts, config.isEnforceUrl())));
        }
    }

    private static boolean isInjectionGloballyDisabled(InjectionConfig config) {
        return config.isDisabled() || InjectionUtil.isInvalid(InjectionConfig.checkRequiredUrl(config.getServer()));
    }

    private static boolean isInjectionEnabledForRepository(InjectionConfig config, SCM scm) {
        if (!config.hasRepositoryFilter()) {
            return true;
        }
        if (scm instanceof GitSCM) {
            List userRemoteConfigs = ((GitSCM)scm).getUserRemoteConfigs();
            for (UserRemoteConfig userRemoteConfig : userRemoteConfigs) {
                String url = userRemoteConfig.getUrl();
                if (url == null) {
                    return true;
                }
                switch (config.matchesRepositoryFilter(url)) {
                    case EXCLUDED: {
                        return false;
                    }
                    case INCLUDED: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean shouldDisableGradleInjection(InjectionConfig config) {
        return InjectionUtil.isValid(InjectionConfig.checkRequiredVersion(config.getGradlePluginVersion()));
    }

    private static boolean shouldDisableMavenInjection(InjectionConfig config) {
        return InjectionUtil.isValid(InjectionConfig.checkRequiredVersion(config.getMavenExtensionVersion()));
    }

    public static final class GradleInjectionDisabledAction
    extends InvisibleAction
    implements EnvironmentContributingAction {
        public static final GradleInjectionDisabledAction INSTANCE = new GradleInjectionDisabledAction();

        private GradleInjectionDisabledAction() {
        }

        public void buildEnvironment(@Nonnull Run<?, ?> run, @Nonnull EnvVars envVars) {
            envVars.put(InitScriptVariables.DEVELOCITY_INJECTION_ENABLED.getEnvVar(), "false");
        }
    }

    public static final class MavenInjectionDisabledAction
    extends InvisibleAction
    implements EnvironmentContributingAction {
        private final String mavenOpts;

        public MavenInjectionDisabledAction(String mavenOpts) {
            this.mavenOpts = mavenOpts;
        }

        public void buildEnvironment(@Nonnull Run<?, ?> run, @Nonnull EnvVars envVars) {
            envVars.put("MAVEN_OPTS", this.mavenOpts);
            envVars.put("JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_EXT_CLASSPATH", "");
        }
    }
}

