/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.collect.Iterables;
import hudson.EnvVars;
import hudson.model.Node;
import hudson.plugins.gradle.injection.InitScriptVariables;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public final class EnvUtil {
    private EnvUtil() {
    }

    @CheckForNull
    public static EnvVars globalEnvironment() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        EnvironmentVariablesNodeProperty nodeProperty = (EnvironmentVariablesNodeProperty)jenkins.getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class);
        return nodeProperty != null ? nodeProperty.getEnvVars() : null;
    }

    @CheckForNull
    public static String getEnv(Node node, String key) {
        List all = node.getNodeProperties().getAll(EnvironmentVariablesNodeProperty.class);
        if (all.isEmpty()) {
            return null;
        }
        EnvironmentVariablesNodeProperty last = (EnvironmentVariablesNodeProperty)Iterables.getLast((Iterable)all);
        return (String)last.getEnvVars().get((Object)key);
    }

    @CheckForNull
    public static String getEnv(EnvVars env, String key) {
        return env != null ? (String)env.get((Object)key) : null;
    }

    public static void removeEnvVars(Node node, Collection<String> keys) {
        keys.forEach(key -> EnvUtil.removeEnvVar(node, key));
    }

    public static void removeEnvVars(Node node, InitScriptVariables[] keys) {
        for (InitScriptVariables key : keys) {
            EnvUtil.removeEnvVar(node, key);
        }
    }

    public static void removeEnvVar(Node node, String key) {
        EnvUtil.setEnvVar(node, key, null);
    }

    public static void removeEnvVar(Node node, InitScriptVariables key) {
        EnvUtil.setEnvVar(node, key, null);
    }

    public static void setEnvVar(Node node, InitScriptVariables key, @Nullable String value) {
        EnvUtil.setEnvVar(node, key.getEnvVar(), value);
    }

    public static void setEnvVar(Node node, String key, @Nullable String value) {
        List all = node.getNodeProperties().getAll(EnvironmentVariablesNodeProperty.class);
        if (all.isEmpty()) {
            if (value != null) {
                node.getNodeProperties().add((Object)new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry(key, value)}));
            }
            return;
        }
        EnvironmentVariablesNodeProperty last = (EnvironmentVariablesNodeProperty)Iterables.getLast((Iterable)all);
        if (!Objects.equals(value, last.getEnvVars().get((Object)key))) {
            if (value != null) {
                last.getEnvVars().put(key, value);
            } else {
                last.getEnvVars().remove((Object)key);
            }
        }
    }
}

