/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.annotations.VisibleForTesting;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.gradle.injection.GradleBuildScanInjection;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenBuildScanInjection;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenExtensionDownloadHandler;
import hudson.slaves.ComputerListener;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class DevelocityComputerListener
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(DevelocityComputerListener.class.getName());
    private final GradleBuildScanInjection gradleBuildScanInjection;
    private final MavenBuildScanInjection mavenBuildScanInjection;
    private final MavenExtensionDownloadHandler mavenExtensionDownloadHandler;
    private final Supplier<InjectionConfig> injectionConfigSupplier;

    public DevelocityComputerListener() {
        this(new GradleBuildScanInjection(), new MavenBuildScanInjection(), new MavenExtensionDownloadHandler(), new JenkinsInjectionConfig());
    }

    @VisibleForTesting
    DevelocityComputerListener(GradleBuildScanInjection gradleBuildScanInjection, MavenBuildScanInjection mavenBuildScanInjection, MavenExtensionDownloadHandler mavenExtensionDownloadHandler, Supplier<InjectionConfig> injectionConfigSupplier) {
        this.gradleBuildScanInjection = gradleBuildScanInjection;
        this.mavenBuildScanInjection = mavenBuildScanInjection;
        this.mavenExtensionDownloadHandler = mavenExtensionDownloadHandler;
        this.injectionConfigSupplier = injectionConfigSupplier;
    }

    public void onOnline(Computer computer, TaskListener listener) {
        try {
            InjectionConfig injectionConfig = this.injectionConfigSupplier.get();
            EnvVars globalEnvVars = computer.buildEnvironment(listener);
            if (InjectionUtil.globalAutoInjectionCheckEnabled(globalEnvVars) && injectionConfig.isDisabled()) {
                return;
            }
            Map<MavenExtension, String> extensionsDigest = this.mavenExtensionDownloadHandler.getExtensionDigests(() -> Jenkins.get().getRootDir(), injectionConfig);
            Node node = computer.getNode();
            EnvVars computerEnvVars = computer.getEnvironment();
            this.gradleBuildScanInjection.inject(node, globalEnvVars, computerEnvVars);
            this.mavenBuildScanInjection.inject(node, extensionsDigest);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            LOGGER.log(Level.WARNING, "Invocation of onOnline failed for " + computer.getName(), t);
        }
    }

    private static final class JenkinsInjectionConfig
    implements Supplier<InjectionConfig> {
        private JenkinsInjectionConfig() {
        }

        @Override
        public InjectionConfig get() {
            return InjectionConfig.get();
        }
    }
}

