/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DevelocityAccessCredentials {
    private static final String KEY_DELIMITER = ";";
    private static final String HOST_DELIMITER = "=";
    private final List<HostnameAccessKey> keys;

    private DevelocityAccessCredentials(List<HostnameAccessKey> keys) {
        this.keys = keys;
    }

    public static DevelocityAccessCredentials of(List<HostnameAccessKey> keys) {
        return new DevelocityAccessCredentials(keys);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public boolean isSingleKey() {
        return this.keys.size() == 1;
    }

    public Optional<HostnameAccessKey> find(String host) {
        return this.keys.stream().filter(k -> k.hostname.equals(host)).findFirst();
    }

    public String getRaw() {
        return this.keys.stream().map(HostnameAccessKey::getRaw).collect(Collectors.joining(KEY_DELIMITER));
    }

    public Stream<HostnameAccessKey> stream() {
        return this.keys.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevelocityAccessCredentials that = (DevelocityAccessCredentials)o;
        return Objects.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return Objects.hashCode(this.keys);
    }

    public static DevelocityAccessCredentials parse(String rawAccessKey) {
        return new DevelocityAccessCredentials(Arrays.stream(rawAccessKey.split(KEY_DELIMITER)).map(k -> k.split(HOST_DELIMITER)).filter(hostKey -> ((String[])hostKey).length == 2).map(hostKey -> new HostnameAccessKey(hostKey[0], hostKey[1])).collect(Collectors.toList()));
    }

    public static boolean isValid(String value) {
        String[] entries;
        if (Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        for (String entry : entries = value.split(KEY_DELIMITER)) {
            String[] parts = entry.split(HOST_DELIMITER, 2);
            if (parts.length < 2) {
                return false;
            }
            String servers = parts[0];
            String accessKey = parts[1];
            if (Strings.isNullOrEmpty((String)servers) || Strings.isNullOrEmpty((String)accessKey)) {
                return false;
            }
            for (String server : servers.split(",")) {
                if (!Strings.isNullOrEmpty((String)server)) continue;
                return false;
            }
        }
        return true;
    }

    public static class HostnameAccessKey {
        private final String hostname;
        private final String key;

        private HostnameAccessKey(String hostname, String key) {
            this.hostname = hostname;
            this.key = key;
        }

        public static HostnameAccessKey of(String hostname, String key) {
            return new HostnameAccessKey(hostname, key);
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getKey() {
            return this.key;
        }

        public String getRaw() {
            return this.hostname + DevelocityAccessCredentials.HOST_DELIMITER + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostnameAccessKey that = (HostnameAccessKey)o;
            return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.key);
        }
    }
}

