/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.enriched;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import hudson.plugins.gradle.enriched.EnrichedSummaryConfig;
import hudson.plugins.gradle.enriched.HttpClientFactory;
import hudson.plugins.gradle.enriched.ScanDetail;
import hudson.util.Secret;
import java.net.URI;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanDetailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanDetailService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String GRADLE_ENTERPRISE_PUBLIC_SERVER = "https://gradle.com";
    private static final String URL_CONTEXT_PATH_SCAN_ID = "/s/";
    private static final String URL_CONTEXT_PATH_API_BUILDS = "/api/builds/";
    private HttpClientFactory httpClientFactory;
    private final boolean isEnrichedSummaryEnabled;
    private final Secret buildScanAccessToken;
    private final String buildScanServer;
    private final int httpClientTimeoutInSeconds;
    private final int httpClientMaxRetries;
    private final int httpClientDelayBetweenRetriesInSeconds;

    void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public ScanDetailService(EnrichedSummaryConfig config) {
        this.isEnrichedSummaryEnabled = config.isEnrichedSummaryEnabled();
        this.buildScanAccessToken = config.getBuildScanAccessKey();
        this.buildScanServer = config.getBuildScanServer();
        this.httpClientTimeoutInSeconds = config.getHttpClientTimeoutInSeconds();
        this.httpClientMaxRetries = config.getHttpClientMaxRetries();
        this.httpClientDelayBetweenRetriesInSeconds = config.getHttpClientDelayBetweenRetriesInSeconds();
        this.httpClientFactory = new HttpClientFactory();
    }

    public Optional<ScanDetail> getScanDetail(String buildScanUrl) {
        if (this.isEnrichedSummaryEnabled && buildScanUrl != null) {
            return Optional.ofNullable(this.doGetScanDetail(buildScanUrl));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScanDetail doGetScanDetail(String buildScanUrl) {
        if (buildScanUrl.startsWith(GRADLE_ENTERPRISE_PUBLIC_SERVER)) {
            return null;
        }
        String baseApiUri = this.getBaseApiUri(buildScanUrl);
        if (null == baseApiUri) return null;
        if (baseApiUri.isEmpty()) {
            return null;
        }
        try (CloseableHttpClient httpclient = this.httpClientFactory.buildHttpClient(this.httpClientTimeoutInSeconds, this.httpClientMaxRetries, this.httpClientDelayBetweenRetriesInSeconds);){
            HttpGet httpGetApiBuilds = this.buildGetRequest(baseApiUri);
            ScanDetail scanDetail = new ScanDetail(buildScanUrl);
            try (CloseableHttpResponse responseApiBuilds = httpclient.execute((HttpUriRequest)httpGetApiBuilds);){
                if (responseApiBuilds.getStatusLine().getStatusCode() != 200) {
                    LOGGER.warn("Unable to fetch build scan data [{}]", (Object)responseApiBuilds.getStatusLine().getStatusCode());
                    ScanDetail scanDetail2 = null;
                    return scanDetail2;
                }
                HttpEntity httpEntityApiBuilds = responseApiBuilds.getEntity();
                if (httpEntityApiBuilds == null) return null;
                String apiBuildsResponse = EntityUtils.toString((HttpEntity)httpEntityApiBuilds);
                ObjectReader objectReader = MAPPER.readerForUpdating((Object)scanDetail);
                String suffix = (scanDetail = (ScanDetail)objectReader.readValue(apiBuildsResponse)).getBuildToolType() != null ? scanDetail.getBuildToolType().getAttributesUrlSuffix() : "unsupported";
                HttpGet httpGetBuildAttributes = this.buildGetRequest(baseApiUri + suffix);
                try (CloseableHttpResponse responseApiBuildAttributes = httpclient.execute((HttpUriRequest)httpGetBuildAttributes);){
                    if (responseApiBuildAttributes.getStatusLine().getStatusCode() != 200) {
                        LOGGER.warn("Unable to fetch build scan data [{}]", (Object)responseApiBuildAttributes.getStatusLine().getStatusCode());
                        ScanDetail scanDetail3 = null;
                        return scanDetail3;
                    }
                    HttpEntity httpEntityApiBuildAttributes = responseApiBuildAttributes.getEntity();
                    if (httpEntityApiBuildAttributes == null) return null;
                    String apiBuildAttributesResponse = EntityUtils.toString((HttpEntity)httpEntityApiBuildAttributes);
                    ScanDetail scanDetail4 = scanDetail = (ScanDetail)objectReader.readValue(apiBuildAttributesResponse);
                    return scanDetail4;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error fetching build scan details", (Throwable)e);
        }
        return null;
    }

    private String getBaseApiUri(String buildScanUrl) {
        int scanIdStartIndex = buildScanUrl.lastIndexOf(URL_CONTEXT_PATH_SCAN_ID);
        if (scanIdStartIndex < 0) {
            LOGGER.warn("Build scan ID can't be parsed in {}", (Object)buildScanUrl);
            return null;
        }
        String scanId = buildScanUrl.substring(scanIdStartIndex + URL_CONTEXT_PATH_SCAN_ID.length());
        try {
            URI baseApiUri = this.buildScanServer != null ? URI.create(this.buildScanServer) : URI.create(buildScanUrl).resolve("/");
            return baseApiUri.resolve(URL_CONTEXT_PATH_API_BUILDS).resolve(scanId).toASCIIString();
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("URL can't be parsed", (Throwable)e);
            return null;
        }
    }

    private HttpGet buildGetRequest(String uri) {
        HttpGet httpGet = new HttpGet(uri);
        if (this.buildScanAccessToken != null) {
            httpGet.addHeader("Authorization", "Bearer " + this.buildScanAccessToken.getPlainText());
        }
        return httpGet;
    }
}

