/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.gradle.BuildScanAction;
import hudson.plugins.gradle.BuildScanFlowAction;
import hudson.plugins.gradle.BuildScansAware;
import hudson.plugins.gradle.GradleTaskListenerDecorator;
import hudson.plugins.gradle.enriched.EnrichedSummaryConfig;
import hudson.plugins.gradle.enriched.ScanDetailService;
import hudson.plugins.gradle.util.RunUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class WithGradleExecution
extends StepExecution {
    WithGradleExecution(StepContext context) {
        super(context);
    }

    public boolean start() throws IOException, InterruptedException {
        GradleTaskListenerDecorator gradleTaskListenerDecorator = new GradleTaskListenerDecorator();
        this.getContext().newBodyInvoker().withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)this.getContext().get(TaskListenerDecorator.class)), (TaskListenerDecorator)gradleTaskListenerDecorator)).withCallback((BodyExecutionCallback)new BuildScanCallback(gradleTaskListenerDecorator, this.getContext())).start();
        return false;
    }

    private static class BuildScanCallback
    extends BodyExecutionCallback {
        private final BuildScansAware buildScans;
        private final StepContext parentContext;

        public BuildScanCallback(BuildScansAware buildScans, StepContext parentContext) {
            this.buildScans = buildScans;
            this.parentContext = parentContext;
        }

        public void onSuccess(StepContext context, Object result) {
            this.parentContext.onSuccess(this.extractBuildScans(context));
        }

        public void onFailure(StepContext context, Throwable t) {
            this.parentContext.onFailure(t);
            this.extractBuildScans(context);
        }

        private List<String> extractBuildScans(StepContext context) {
            try {
                List<String> buildScans = this.buildScans.getBuildScans();
                if (buildScans.isEmpty()) {
                    return Collections.emptyList();
                }
                FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
                flowNode.getParents().stream().findFirst().ifPresent(parent -> {
                    BuildScanFlowAction nodeBuildScanAction = new BuildScanFlowAction((FlowNode)parent);
                    buildScans.forEach(nodeBuildScanAction::addScanUrl);
                    parent.addAction((Action)nodeBuildScanAction);
                });
                ScanDetailService scanDetailService = new ScanDetailService(EnrichedSummaryConfig.get());
                Run run = (Run)context.get(Run.class);
                RunUtil.getOrCreateAction(run, BuildScanAction.class, BuildScanAction::new).addScanUrls(buildScans, scanDetailService::getScanDetail);
                return buildScans;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

