/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.plugins.gradle.AbstractGradleLogProcessor;
import hudson.plugins.gradle.BuildScanLogScanner;
import hudson.plugins.gradle.BuildScanPublishedListener;
import hudson.plugins.gradle.GradleOutcomeNote;
import hudson.plugins.gradle.GradleTaskNote;
import hudson.plugins.gradle.TimestampPrefixDetector;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class GradleConsoleAnnotator
extends AbstractGradleLogProcessor {
    private final boolean annotateGradleOutput;
    private final BuildScanLogScanner buildScanLogScanner;
    private transient Integer timestampPrefix;

    public GradleConsoleAnnotator(OutputStream out, Charset charset, boolean annotateGradleOutput, BuildScanPublishedListener buildScanListener) {
        super(out, charset);
        this.annotateGradleOutput = annotateGradleOutput;
        this.buildScanLogScanner = new BuildScanLogScanner(buildScanListener);
    }

    @Override
    protected void processLogLine(String line) throws IOException {
        line = this.trimEOL(line);
        if (this.annotateGradleOutput) {
            if (this.timestampPrefix == null) {
                this.timestampPrefix = TimestampPrefixDetector.detectTimestampPrefix(line);
            }
            if ((line = TimestampPrefixDetector.trimTimestampPrefix(this.timestampPrefix, line)).startsWith(":") || line.startsWith("> Task :")) {
                new GradleTaskNote().encodeTo(this.out);
            }
            if (line.startsWith("BUILD SUCCESSFUL") || line.startsWith("BUILD FAILED")) {
                new GradleOutcomeNote().encodeTo(this.out);
            }
        }
        this.buildScanLogScanner.scanLine(line);
    }
}

