/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AbstractGradleLogProcessor
extends LineTransformationOutputStream {
    private static final int DEFAULT_MAX_LINE_LENGTH = 500;
    private final int maxLineLength;
    protected final OutputStream out;
    protected final Charset charset;

    protected AbstractGradleLogProcessor(OutputStream out, Charset charset) {
        this(500, out, charset);
    }

    protected AbstractGradleLogProcessor(int maxLineLength, OutputStream out, Charset charset) {
        this.maxLineLength = maxLineLength;
        this.out = out;
        this.charset = charset;
    }

    protected final void eol(byte[] bytes, int length) throws IOException {
        if (length < this.maxLineLength) {
            String line = this.charset.decode(ByteBuffer.wrap(bytes, 0, length)).toString();
            this.processLogLine(line);
        }
        this.out.write(bytes, 0, length);
    }

    protected abstract void processLogLine(String var1) throws IOException;

    public final void flush() throws IOException {
        this.out.flush();
    }

    public final void close() throws IOException {
        super.close();
        this.out.close();
    }
}

