/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.util;

import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.util.Executor;
import com.google.jenkins.plugins.util.ExecutorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryStorageOperation {
    private static final Logger logger = Logger.getLogger(RetryStorageOperation.class.getName());
    public static final int MAX_REMOTE_CREDENTIAL_EXPIRED_RETRIES = 1;

    public static void performRequestWithRetry(Executor executor, Operation a, int attempts) throws IOException, InterruptedException, ExecutorException {
        IOException lastIOException = null;
        InterruptedException lastInterruptedException = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                a.act();
                return;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, Messages.AbstractUpload_UploadError(i), e);
                lastIOException = e;
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, Messages.AbstractUpload_UploadError(i), e);
                lastInterruptedException = e;
            }
            executor.sleep();
        }
        if (lastIOException != null) {
            throw lastIOException;
        }
        throw (InterruptedException)Preconditions.checkNotNull(lastInterruptedException);
    }

    public static <Ex extends Throwable> void performRequestWithReinitCredentials(RepeatOperation<Ex> a, int retries) throws IOException, InterruptedException, ExecutorException, Ex {
        int budget = retries;
        do {
            a.initCredentials();
            try {
                while (a.moreWork()) {
                    a.act();
                    budget = retries;
                }
            }
            catch (HttpResponseException e) {
                if (budget > 0 && e.getStatusCode() == 401) {
                    logger.fine("Remote credentials expired, retrying.");
                    --budget;
                    continue;
                }
                throw new IOException(Messages.AbstractUpload_ExceptionFileUpload(), e);
            }
        } while (a.moreWork());
    }

    public static <Ex extends Throwable> void performRequestWithReinitCredentials(RepeatOperation<Ex> a) throws IOException, InterruptedException, ExecutorException, Ex {
        RetryStorageOperation.performRequestWithReinitCredentials(a, 1);
    }

    public static interface Operation {
        public void act() throws IOException, InterruptedException, ExecutorException;
    }

    public static interface RepeatOperation<Ex extends Throwable> {
        public void initCredentials() throws IOException, Ex;

        public void act() throws HttpResponseException, IOException, InterruptedException, ExecutorException, Ex;

        public boolean moreWork();
    }
}

