/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.util;

import com.google.jenkins.plugins.storage.Messages;
import java.io.Serializable;

public class BucketPath
implements Serializable {
    private final String bucket;
    private final String object;

    public BucketPath(String uri) throws IllegalArgumentException {
        if (!uri.startsWith("gs://")) {
            throw new IllegalArgumentException(Messages.AbstractUploadDescriptor_BadPrefix(uri, "gs://"));
        }
        uri = uri.substring("gs://".length());
        String[] halves = uri.split("/", 2);
        this.bucket = halves[0];
        this.object = halves.length == 1 ? "" : halves[1];
    }

    public BucketPath(String bucket, String object) {
        this.bucket = bucket;
        this.object = object;
    }

    public boolean error() {
        return this.getBucket().length() <= 0;
    }

    public String getPath() {
        return this.bucket + (String)(this.object.isEmpty() ? "" : "/" + this.object);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObject() {
        return this.object;
    }
}

