/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.reports;

import com.google.api.client.util.Sets;
import com.google.jenkins.plugins.storage.reports.AbstractGcsUploadReport;
import com.google.jenkins.plugins.storage.util.BucketPath;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Run;
import java.util.Collections;
import java.util.Set;

public class BuildGcsUploadReport
extends AbstractGcsUploadReport {
    private final Set<String> buckets = Sets.newHashSet();
    private final Set<String> files = Sets.newHashSet();

    public BuildGcsUploadReport(Run<?, ?> run) {
        super((Actionable)run);
    }

    @Nullable
    public static BuildGcsUploadReport of(AbstractProject<?, ?> project) {
        AbstractBuild lastBuild = project.getLastBuild();
        return lastBuild == null ? null : BuildGcsUploadReport.of(lastBuild);
    }

    public static synchronized BuildGcsUploadReport of(Run<?, ?> run) {
        BuildGcsUploadReport links = (BuildGcsUploadReport)run.getAction(BuildGcsUploadReport.class);
        if (links != null) {
            return links;
        }
        links = new BuildGcsUploadReport(run);
        run.addAction((Action)links);
        return links;
    }

    public void addBucket(String bucketName) {
        this.buckets.add(bucketName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpload(String relativePath, BucketPath bucket) {
        Set<String> set = this.files;
        synchronized (set) {
            this.files.add(bucket.getPath() + "/" + relativePath);
        }
    }

    @Override
    public Set<String> getBuckets() {
        return Collections.unmodifiableSet(this.buckets);
    }

    @Override
    public Set<String> getStorageObjects() {
        return Collections.unmodifiableSet(this.files);
    }

    @Override
    public Integer getBuildNumber() {
        return ((AbstractBuild)this.getParent()).getNumber();
    }
}

