/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.client;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;

public class StorageClient {
    private final Storage storage;

    public StorageClient(Storage storage) {
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
    }

    public void deleteFromBucket(String bucket, String pattern) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0);
        this.deleteFromBucketRequest(bucket, pattern).execute();
    }

    public Storage.Objects.Delete deleteFromBucketRequest(String bucket, String pattern) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0);
        return this.storage.objects().delete(bucket, pattern);
    }

    public StorageObject uploadToBucket(String pattern, String bucket, InputStreamContent content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0);
        return (StorageObject)this.uploadToBucketRequest(pattern, bucket, content).execute();
    }

    public Storage.Objects.Insert uploadToBucketRequest(String pattern, String bucket, InputStreamContent content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pattern) ? 1 : 0) != 0);
        return this.storage.objects().insert(bucket, null, (AbstractInputStreamContent)content).setName(pattern);
    }

    public void deleteBucket(String bucket) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        this.deleteBucketRequest(bucket).execute();
    }

    public Storage.Buckets.Delete deleteBucketRequest(String bucket) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        return this.storage.buckets().delete(bucket);
    }
}

