/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.jenkins.plugins.credentials.domains.DomainRequirementProvider;
import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.util.Executor;
import hudson.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import jenkins.model.Jenkins;

@RequiresDomain(value=StorageScopeRequirement.class)
public class UploadModule {
    private static final String PLUGIN_NAME = "google-storage-plugin";

    public Executor newExecutor() {
        return new Executor.Default();
    }

    public StorageScopeRequirement getRequirement() {
        return (StorageScopeRequirement)DomainRequirementProvider.of(this.getClass(), StorageScopeRequirement.class);
    }

    public String getVersion() {
        String version = "";
        Plugin plugin = Jenkins.get().getPlugin(PLUGIN_NAME);
        if (plugin != null) {
            version = plugin.getWrapper().getVersion();
        }
        return version;
    }

    public Storage getStorageService(GoogleRobotCredentials credentials, String version) throws IOException {
        try {
            String appName = Messages.UploadModule_AppName();
            if (version.length() > 0) {
                version = version.split(" ")[0];
                appName = appName.concat("/").concat(version);
            }
            return new Storage.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credentials.getGoogleCredential((GoogleOAuth2ScopeRequirement)this.getRequirement())).setApplicationName(appName).build();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(Messages.UploadModule_ExceptionStorageService(), e);
        }
    }

    public int getInsertRetryCount() {
        return 5;
    }

    public String prefix(String logMessage) {
        return Messages.StorageUtil_PrefixFormat(Messages.GoogleCloudStorageUploader_DisplayName(), logMessage);
    }

    public InputStream executeMediaAsInputStream(Storage.Objects.Get getObject) throws IOException {
        return getObject.executeMediaAsInputStream();
    }
}

