/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StdoutUpload;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@RequiresDomain(value=StorageScopeRequirement.class)
public class StdoutUploadStep
extends Recorder
implements SimpleBuildStep,
Serializable {
    private StdoutUpload upload;
    private final String credentialsId;

    @DataBoundConstructor
    public StdoutUploadStep(String credentialsId, String bucket, String logName) {
        this(credentialsId, bucket, Optional.ofNullable(null), logName);
    }

    public StdoutUploadStep(String credentialsId, String bucket, Optional<UploadModule> module, String logName) {
        this.credentialsId = credentialsId;
        this.upload = new StdoutUpload(bucket, module.orElse(null), logName, null);
    }

    @DataBoundSetter
    public void setSharedPublicly(boolean sharedPublicly) {
        this.upload.setSharedPublicly(sharedPublicly);
    }

    public boolean isSharedPublicly() {
        return this.upload.isSharedPublicly();
    }

    @DataBoundSetter
    public void setShowInline(boolean showInline) {
        this.upload.setShowInline(showInline);
    }

    public boolean isShowInline() {
        return this.upload.isShowInline();
    }

    @DataBoundSetter
    public void setPathPrefix(@Nullable String pathPrefix) {
        this.upload.setPathPrefix(pathPrefix);
    }

    @Nullable
    public String getPathPrefix() {
        return this.upload.getPathPrefix();
    }

    public String getLogName() {
        return this.upload.getLogName();
    }

    public String getBucket() {
        return this.upload.getBucket();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        try {
            this.upload.perform(this.getCredentialsId(), run, workspace, listener);
        }
        catch (UploadException e) {
            throw new IOException(Messages.StdoutUpload_FailToUpload(), e);
        }
    }

    @Extension
    @Symbol(value={"googleStorageBuildLogUpload"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.StdoutUpload_BuildStepDisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckBucket(@QueryParameter String bucket) {
            return StdoutUpload.DescriptorImpl.staticDoCheckBucket(bucket);
        }

        public static FormValidation doCheckLogName(@QueryParameter String logName) {
            return new StdoutUpload.DescriptorImpl().doCheckLogName(logName);
        }

        public Publisher newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (Boolean.FALSE.equals(formData.remove("stripPathPrefix"))) {
                formData.remove("pathPrefix");
            }
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

