/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.AbstractUpload;
import com.google.jenkins.plugins.storage.AbstractUploadDescriptor;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StdoutUpload;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.reports.ProjectGcsUploadReport;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

@RequiresDomain(value=StorageScopeRequirement.class)
public class GoogleCloudStorageUploader
extends Recorder {
    private final String credentialsId;
    private final List<AbstractUpload> uploads;

    @DataBoundConstructor
    public GoogleCloudStorageUploader(String credentialsId, @Nullable List<AbstractUpload> uploads) {
        this.credentialsId = (String)Preconditions.checkNotNull((Object)credentialsId);
        if (uploads == null) {
            this.uploads = ImmutableList.of();
        } else {
            Preconditions.checkArgument((uploads.size() > 0 ? 1 : 0) != 0);
            this.uploads = uploads;
        }
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public GoogleRobotCredentials getCredentials() {
        return GoogleRobotCredentials.getById((String)this.getCredentialsId());
    }

    public Collection<AbstractUpload> getUploads() {
        return Collections.unmodifiableCollection(this.uploads);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        boolean result = true;
        for (AbstractUpload upload : this.uploads) {
            try {
                upload.perform(this.getCredentialsId(), build, (TaskListener)listener);
            }
            catch (UploadException e) {
                e.printStackTrace(listener.error(Messages.StorageUtil_PrefixFormat(this.getDescriptor().getDisplayName(), Messages.GoogleCloudStorageUploader_ExceptionDuringUpload(e.getMessage()))));
                build.setResult(Result.FAILURE);
                result = false;
            }
        }
        return result;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new ProjectGcsUploadReport(project);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GoogleCloudStorageUploader_DisplayName();
        }

        public List<AbstractUpload> getDefaultUploads() {
            StdoutUpload upload = new StdoutUpload("gs://", null, "build-log.txt", null);
            upload.setForFailedJobs(true);
            return ImmutableList.of((Object)upload);
        }

        public List<AbstractUploadDescriptor> getUploads() {
            return AbstractUpload.all();
        }
    }
}

