/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.ClassicUpload;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.storage.util.BucketPath;
import com.google.jenkins.plugins.storage.util.RetryStorageOperation;
import com.google.jenkins.plugins.storage.util.StorageUtil;
import com.google.jenkins.plugins.util.Executor;
import com.google.jenkins.plugins.util.ExecutorException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@RequiresDomain(value=StorageScopeRequirement.class)
public class DownloadStep
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DownloadStep.class.getName());
    private final String credentialsId;
    private final String bucketUri;
    private final String localDirectory;
    private String pathPrefix;
    private final transient UploadModule module;

    @DataBoundConstructor
    public DownloadStep(String credentialsId, String bucketUri, String localDirectory) {
        this(credentialsId, bucketUri, localDirectory, null);
    }

    public DownloadStep(String credentialsId, String bucketUri, String localDirectory, @Nullable UploadModule module) {
        this.module = module != null ? module : new UploadModule();
        this.bucketUri = bucketUri;
        this.credentialsId = credentialsId;
        this.localDirectory = localDirectory;
    }

    public String getBucketUri() {
        return this.bucketUri;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    @DataBoundSetter
    public void setPathPrefix(@Nullable String pathPrefix) {
        if (pathPrefix != null && !((String)pathPrefix).endsWith("/")) {
            pathPrefix = (String)pathPrefix + "/";
        }
        this.pathPrefix = pathPrefix;
    }

    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    protected synchronized UploadModule getModule() {
        if (this.module == null) {
            return new UploadModule();
        }
        return this.module;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public GoogleRobotCredentials getCredentials() {
        return GoogleRobotCredentials.getById((String)this.getCredentialsId());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try {
            String version = this.getModule().getVersion();
            String path = StorageUtil.replaceMacro(this.getBucketUri(), run, listener);
            BucketPath bucketPath = new BucketPath(path);
            if (bucketPath.error()) {
                throw new IOException("Invalid bucket path: " + this.getBucketUri());
            }
            String dirName = StorageUtil.replaceMacro(this.getLocalDirectory(), run, listener);
            FilePath dirPath = workspace.child(dirName);
            List<StorageObjectId> objects = this.resolveBucketPath(bucketPath, this.getCredentials(), version);
            listener.getLogger().println(this.getModule().prefix(Messages.Download_FoundForPattern(objects.size(), path)));
            String resolvedPrefix = StorageUtil.replaceMacro(this.pathPrefix, run, listener);
            this.initiateDownloadsAtWorkspace(this.getCredentials(), objects, dirPath, listener, version, resolvedPrefix);
        }
        catch (ExecutorException e) {
            throw new IOException(Messages.Download_DownloadException(), e);
        }
    }

    private void performDownloadWithRetry(Executor executor, final Storage service, final StorageObjectId obj, final FilePath localName, final UploadModule module, final TaskListener listener) throws IOException, InterruptedException, ExecutorException {
        RetryStorageOperation.Operation a = new RetryStorageOperation.Operation(){

            @Override
            public void act() throws IOException, InterruptedException, ExecutorException {
                listener.getLogger().println(module.prefix(Messages.Download_Downloading(obj.getName(), localName)));
                Storage.Objects.Get getObject = service.objects().get(obj.getBucket(), obj.getName());
                MediaHttpDownloader downloader = getObject.getMediaHttpDownloader();
                if (downloader != null) {
                    downloader.setDirectDownloadEnabled(true);
                }
                InputStream is = module.executeMediaAsInputStream(getObject);
                localName.copyFrom(is);
            }
        };
        RetryStorageOperation.performRequestWithRetry(executor, a, module.getInsertRetryCount());
    }

    private void performDownloads(final GoogleRobotCredentials credentials, final FilePath localDir, final List<StorageObjectId> objs, final TaskListener listener, final String version, final String resolvedPrefix) throws IOException {
        RetryStorageOperation.RepeatOperation<IOException> a = new RetryStorageOperation.RepeatOperation<IOException>(){
            private Queue<StorageObjectId> objects;
            Executor executor;
            Storage service;
            {
                this.objects = new LinkedList<StorageObjectId>(objs);
                this.executor = DownloadStep.this.getModule().newExecutor();
            }

            @Override
            public void initCredentials() throws IOException {
                this.service = DownloadStep.this.getModule().getStorageService(credentials, version);
            }

            @Override
            public boolean moreWork() {
                return !this.objects.isEmpty();
            }

            @Override
            public void act() throws IOException, InterruptedException, ExecutorException {
                StorageObjectId obj = this.objects.peek();
                String addPath = StorageUtil.getStrippedFilename(obj.getName(), resolvedPrefix);
                FilePath localName = localDir.withSuffix("/" + addPath);
                DownloadStep.this.performDownloadWithRetry(this.executor, this.service, obj, localName, DownloadStep.this.getModule(), listener);
                this.objects.remove();
            }
        };
        try {
            RetryStorageOperation.performRequestWithReinitCredentials(a);
        }
        catch (ExecutorException e) {
            throw new IOException(Messages.Download_DownloadException(), e);
        }
        catch (InterruptedException e) {
            throw new IOException(Messages.Download_DownloadException(), e);
        }
    }

    private void initiateDownloadsAtWorkspace(GoogleRobotCredentials credentials, final List<StorageObjectId> objects, final FilePath localDir, final TaskListener listener, final String version, final String resolvedPrefix) throws IOException, InterruptedException {
        try {
            final GoogleRobotCredentials remoteCredentials = ((GoogleRobotCredentials)Preconditions.checkNotNull((Object)credentials)).forRemote((GoogleOAuth2ScopeRequirement)this.getModule().getRequirement());
            localDir.act((Callable)new MasterToSlaveCallable<Void, IOException>(){

                public Void call() throws IOException {
                    DownloadStep.this.performDownloads(remoteCredentials, localDir, objects, listener, version, resolvedPrefix);
                    return null;
                }
            });
        }
        catch (GeneralSecurityException e) {
            throw new IOException(Messages.AbstractUpload_RemoteCredentialError(), e);
        }
    }

    public static String[] split(String uri) throws AbortException {
        int occurs = StringUtils.countMatches((String)uri, (String)"*");
        if (occurs == 0) {
            return new String[]{uri};
        }
        if (occurs > 1) {
            throw new AbortException(Messages.Download_UnsupportedMultipleAsterisks(uri));
        }
        int index = uri.indexOf(42);
        return new String[]{uri.substring(0, index), uri.substring(index + 1)};
    }

    private static void verifySupported(BucketPath path) throws AbortException {
        if (path.getBucket().contains("*")) {
            throw new AbortException(Messages.Download_UnsupportedAsteriskInBucket(path.getBucket()));
        }
        String[] pieces = DownloadStep.split(path.getObject());
        if (pieces.length == 2 && pieces[1].contains("/")) {
            throw new AbortException(Messages.Download_UnsupportedDirSuffix(path.getObject()));
        }
    }

    private List<StorageObjectId> resolveBucketPath(BucketPath bucketPath, GoogleRobotCredentials credentials, String version) throws IOException, ExecutorException {
        Storage service = this.getModule().getStorageService(credentials, version);
        Executor executor = this.getModule().newExecutor();
        ArrayList<StorageObjectId> result = new ArrayList<StorageObjectId>();
        DownloadStep.verifySupported(bucketPath);
        String[] pieces = DownloadStep.split(bucketPath.getObject());
        if (pieces.length == 1) {
            Storage.Objects.Get obj = service.objects().get(bucketPath.getBucket(), bucketPath.getObject());
            result.add(new StorageObjectId((StorageObject)executor.execute((AbstractGoogleJsonClientRequest)obj)));
            return result;
        }
        String bucketPathPrefix = pieces[0];
        String bucketPathSuffix = pieces[1];
        String pageToken = "";
        do {
            Storage.Objects.List list = service.objects().list(bucketPath.getBucket()).setPrefix(bucketPathPrefix).setDelimiter("/");
            if (pageToken.length() > 0) {
                list.setPageToken(pageToken);
            }
            Objects objects = (Objects)executor.execute((AbstractGoogleJsonClientRequest)list);
            pageToken = objects.getNextPageToken();
            for (StorageObject o : objects.getItems()) {
                if (!o.getName().endsWith(bucketPathSuffix)) continue;
                result.add(new StorageObjectId(o));
            }
        } while (pageToken != null && pageToken.length() > 0);
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)((Jenkins)Preconditions.checkNotNull((Object)Jenkins.get())).getDescriptor(this.getClass());
    }

    protected static class StorageObjectId
    implements Serializable {
        private final String bucket;
        private final String name;

        public StorageObjectId(StorageObject obj) {
            this.bucket = obj.getBucket();
            this.name = obj.getName();
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getName() {
            return this.name;
        }
    }

    @Extension
    @Symbol(value={"googleStorageDownload"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private UploadModule module = new UploadModule();

        public synchronized UploadModule getModule() {
            if (this.module == null) {
                return new UploadModule();
            }
            return this.module;
        }

        public String getDisplayName() {
            return Messages.Download_BuildStepDisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Builder newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (Boolean.FALSE.equals(formData.remove("stripPathPrefix"))) {
                formData.remove("pathPrefix");
            }
            return (Builder)super.newInstance(req, formData);
        }

        public FormValidation doCheckBucketUri(@QueryParameter String bucketUri) {
            try {
                BucketPath path = new BucketPath(bucketUri);
                DownloadStep.verifySupported(path);
            }
            catch (AbortException e) {
                return FormValidation.error((String)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return ClassicUpload.DescriptorImpl.staticDoCheckBucket(bucketUri);
        }
    }
}

