/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.storage.ClassicUpload;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@RequiresDomain(value=StorageScopeRequirement.class)
public class ClassicUploadStep
extends Builder
implements SimpleBuildStep,
Serializable {
    private ClassicUpload upload;
    private final String credentialsId;

    @DataBoundConstructor
    public ClassicUploadStep(String credentialsId, String bucket, String pattern) {
        this(credentialsId, bucket, null, pattern);
    }

    public ClassicUploadStep(String credentialsId, String bucket, @Nullable UploadModule module, String pattern) {
        this.credentialsId = credentialsId;
        this.upload = new ClassicUpload(bucket, module, pattern, null, null);
        this.upload.setForFailedJobs(true);
    }

    @DataBoundSetter
    public void setSharedPublicly(boolean sharedPublicly) {
        this.upload.setSharedPublicly(sharedPublicly);
    }

    public boolean isSharedPublicly() {
        return this.upload.isSharedPublicly();
    }

    @DataBoundSetter
    public void setShowInline(boolean showInline) {
        this.upload.setShowInline(showInline);
    }

    public boolean isShowInline() {
        return this.upload.isShowInline();
    }

    @DataBoundSetter
    public void setPathPrefix(@Nullable String pathPrefix) {
        this.upload.setPathPrefix(pathPrefix);
    }

    @Nullable
    public String getPathPrefix() {
        return this.upload.getPathPrefix();
    }

    public String getPattern() {
        return this.upload.getPattern();
    }

    public String getBucket() {
        return this.upload.getBucket();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        this.upload.setForFailedJobs(true);
        try {
            this.upload.perform(this.getCredentialsId(), run, workspace, listener);
        }
        catch (UploadException e) {
            throw new IOException("Could not perform upload", e);
        }
    }

    @Extension
    @Symbol(value={"googleStorageUpload"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.ClassicUpload_BuildStepDisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Builder newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (Boolean.FALSE.equals(formData.remove("stripPathPrefix"))) {
                formData.remove("pathPrefix");
            }
            return (Builder)super.newInstance(req, formData);
        }

        public FormValidation doCheckBucket(@QueryParameter String bucket) {
            return ClassicUpload.DescriptorImpl.staticDoCheckBucket(bucket);
        }

        public static FormValidation doCheckPattern(@QueryParameter String pattern) {
            return ClassicUpload.DescriptorImpl.staticDoCheckPattern(pattern);
        }
    }
}

