/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.jenkins.plugins.storage.AbstractUpload;
import com.google.jenkins.plugins.storage.AbstractUploadDescriptor;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.storage.util.StorageUtil;
import com.google.jenkins.plugins.util.Resolve;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ClassicUpload
extends AbstractUpload {
    private final String sourceGlobWithVars;

    @DataBoundConstructor
    public ClassicUpload(String bucket, @Nullable UploadModule module, String pattern, @Deprecated @Nullable String bucketNameWithVars, @Deprecated @Nullable String sourceGlobWithVars) {
        super(bucket != null ? bucket : bucketNameWithVars, module);
        this.sourceGlobWithVars = pattern != null ? pattern : sourceGlobWithVars;
        Objects.requireNonNull(this.sourceGlobWithVars);
    }

    @Override
    public String getDetails() {
        return this.getPattern();
    }

    @Override
    @Nullable
    protected AbstractUpload.UploadSpec getInclusions(Run<?, ?> run, FilePath workspace, TaskListener listener) throws UploadException {
        try {
            FilePath[] inclusions;
            String globResolvedVars = StorageUtil.replaceMacro(this.getPattern(), run, listener);
            if (globResolvedVars.startsWith("/")) {
                workspace = this.getRoot(workspace);
                globResolvedVars = globResolvedVars.substring(1);
            }
            if ((inclusions = workspace.list(globResolvedVars)).length == 0) {
                listener.error(this.getModule().prefix(Messages.ClassicUpload_NoArtifacts(globResolvedVars)));
                return null;
            }
            listener.getLogger().println(this.getModule().prefix(Messages.ClassicUpload_FoundForPattern(inclusions.length, this.getPattern())));
            return new AbstractUpload.UploadSpec(workspace, Arrays.asList(inclusions));
        }
        catch (InterruptedException e) {
            throw new UploadException(Messages.AbstractUpload_IncludeException(), e);
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_IncludeException(), e);
        }
    }

    private FilePath getRoot(FilePath workspace) {
        FilePath iter = workspace;
        while (iter.getParent() != null) {
            iter = iter.getParent();
        }
        return iter;
    }

    public String getPattern() {
        return this.sourceGlobWithVars;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractUploadDescriptor {
        public DescriptorImpl() {
            this((Class<? extends ClassicUpload>)ClassicUpload.class);
        }

        public DescriptorImpl(Class<? extends ClassicUpload> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return Messages.ClassicUpload_DisplayName();
        }

        public static FormValidation staticDoCheckPattern(@QueryParameter String pattern) {
            String resolvedInput = Resolve.resolveBuiltin((String)pattern);
            if (resolvedInput.isEmpty()) {
                return FormValidation.error((String)Messages.ClassicUpload_EmptyGlob());
            }
            if (resolvedInput.contains("$")) {
                return FormValidation.error((String)Messages.ClassicUpload_BadGlobChar("$", Messages.AbstractUploadDescriptor_DollarSuggest()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPattern(@QueryParameter String pattern) {
            return DescriptorImpl.staticDoCheckPattern(pattern);
        }
    }
}

