/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.storage.AbstractUpload;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.util.Resolve;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AbstractUploadDescriptor
extends Descriptor<AbstractUpload> {
    public static final String GCS_SCHEME = "gs://";
    private final UploadModule module;

    protected AbstractUploadDescriptor(Class<? extends AbstractUpload> clazz, UploadModule module) {
        super((Class)Preconditions.checkNotNull(clazz));
        this.module = module;
    }

    protected AbstractUploadDescriptor(Class<? extends AbstractUpload> clazz) {
        this((Class)Preconditions.checkNotNull(clazz), new UploadModule());
    }

    public synchronized UploadModule getModule() {
        if (this.module == null) {
            return new UploadModule();
        }
        return this.module;
    }

    public static FormValidation staticDoCheckBucket(String bucketNameWithVars) {
        String resolvedInput = Resolve.resolveBuiltin((String)bucketNameWithVars);
        if (!resolvedInput.startsWith(GCS_SCHEME)) {
            return FormValidation.error((String)Messages.AbstractUploadDescriptor_BadPrefix(resolvedInput, GCS_SCHEME));
        }
        if ((resolvedInput = resolvedInput.substring(GCS_SCHEME.length())).isEmpty()) {
            return FormValidation.error((String)Messages.AbstractUploadDescriptor_EmptyBucketName());
        }
        if (resolvedInput.contains("$")) {
            return FormValidation.error((String)Messages.AbstractUploadDescriptor_BadBucketChar("$", Messages.AbstractUploadDescriptor_DollarSuggest()));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckBucketNameWithVars(@QueryParameter String bucketNameWithVars) throws IOException {
        return AbstractUploadDescriptor.staticDoCheckBucket(bucketNameWithVars);
    }

    public FormValidation doCheckBucket(@QueryParameter String bucket) throws IOException {
        return AbstractUploadDescriptor.staticDoCheckBucket(bucket);
    }

    public AbstractUpload newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        if (Boolean.FALSE.equals(formData.remove("stripPathPrefix"))) {
            formData.remove("pathPrefix");
        }
        return (AbstractUpload)super.newInstance(req, formData);
    }
}

