/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.util;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.jenkins.plugins.util.ExecutorException;
import java.io.IOException;
import java.util.concurrent.Callable;

public abstract class RequestCallable<T>
implements Callable<T> {
    @Override
    public abstract T call() throws IOException, ExecutorException;

    public boolean canRetry() {
        return true;
    }

    public static <R> RequestCallable<R> from(final AbstractGoogleJsonClientRequest<R> request) {
        return new RequestCallable<R>(){

            @Override
            public R call() throws IOException {
                return request.execute();
            }

            @Override
            public boolean canRetry() {
                return request.getMediaHttpUploader() == null;
            }
        };
    }
}

