/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public final class JsonKey
extends GenericJson {
    @Key(value="client_email")
    private String clientEmail;
    @Key(value="private_key")
    private String privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonKey load(JsonFactory jsonFactory, InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, Charsets.UTF_8);
        try {
            Secret decoded = Secret.fromString((String)IOUtils.toString((Reader)reader));
            JsonKey jsonKey = (JsonKey)((Object)jsonFactory.fromString(decoded.getPlainText(), JsonKey.class));
            return jsonKey;
        }
        finally {
            inputStream.close();
        }
    }

    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }
}

