/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.containeranalysis.v1beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.containeranalysis.v1beta1.ContainerAnalysisRequest;
import com.google.api.services.containeranalysis.v1beta1.ContainerAnalysisRequestInitializer;
import com.google.api.services.containeranalysis.v1beta1.model.BatchCreateNotesRequest;
import com.google.api.services.containeranalysis.v1beta1.model.BatchCreateNotesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.BatchCreateOccurrencesRequest;
import com.google.api.services.containeranalysis.v1beta1.model.BatchCreateOccurrencesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.Empty;
import com.google.api.services.containeranalysis.v1beta1.model.GetIamPolicyRequest;
import com.google.api.services.containeranalysis.v1beta1.model.ListNoteOccurrencesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.ListNotesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.ListOccurrencesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.ListScanConfigsResponse;
import com.google.api.services.containeranalysis.v1beta1.model.Note;
import com.google.api.services.containeranalysis.v1beta1.model.Occurrence;
import com.google.api.services.containeranalysis.v1beta1.model.Policy;
import com.google.api.services.containeranalysis.v1beta1.model.ScanConfig;
import com.google.api.services.containeranalysis.v1beta1.model.SetIamPolicyRequest;
import com.google.api.services.containeranalysis.v1beta1.model.TestIamPermissionsRequest;
import com.google.api.services.containeranalysis.v1beta1.model.TestIamPermissionsResponse;
import com.google.api.services.containeranalysis.v1beta1.model.VulnerabilityOccurrencesSummary;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerAnalysis
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://containeranalysis.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://containeranalysis.googleapis.com/";

    public ContainerAnalysis(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    ContainerAnalysis(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Container Analysis API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://containeranalysis.googleapis.com/", ContainerAnalysis.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ContainerAnalysis.DEFAULT_BATCH_PATH);
        }

        public ContainerAnalysis build() {
            return new ContainerAnalysis(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setContainerAnalysisRequestInitializer(ContainerAnalysisRequestInitializer containerAnalysisRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)containerAnalysisRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Notes notes() {
            return new Notes();
        }

        public Occurrences occurrences() {
            return new Occurrences();
        }

        public ScanConfigs scanConfigs() {
            return new ScanConfigs();
        }

        public class ScanConfigs {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, ScanConfig scanConfig) throws IOException {
                Update update = new Update(string, scanConfig);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends ContainerAnalysisRequest<ScanConfig> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String string, ScanConfig scanConfig) {
                    super(ContainerAnalysis.this, "PUT", REST_PATH, (Object)scanConfig, ScanConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/scanConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/scanConfigs/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/scanConfigs/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ContainerAnalysisRequest<ListScanConfigsResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/scanConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, ListScanConfigsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ContainerAnalysisRequest<ScanConfig> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, ScanConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/scanConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/scanConfigs/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/scanConfigs/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Occurrences {
            public BatchCreate batchCreate(String string, BatchCreateOccurrencesRequest batchCreateOccurrencesRequest) throws IOException {
                BatchCreate batchCreate = new BatchCreate(string, batchCreateOccurrencesRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)batchCreate);
                return batchCreate;
            }

            public Create create(String string, Occurrence occurrence) throws IOException {
                Create create = new Create(string, occurrence);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public GetNotes getNotes(String string) throws IOException {
                GetNotes getNotes = new GetNotes(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)getNotes);
                return getNotes;
            }

            public GetVulnerabilitySummary getVulnerabilitySummary(String string) throws IOException {
                GetVulnerabilitySummary getVulnerabilitySummary = new GetVulnerabilitySummary(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)getVulnerabilitySummary);
                return getVulnerabilitySummary;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Occurrence occurrence) throws IOException {
                Patch patch = new Patch(string, occurrence);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends ContainerAnalysisRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends ContainerAnalysisRequest<Policy> {
                private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends ContainerAnalysisRequest<Occurrence> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Occurrence occurrence) {
                    super(ContainerAnalysis.this, "PATCH", REST_PATH, (Object)occurrence, Occurrence.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ContainerAnalysisRequest<ListOccurrencesResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/occurrences";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, ListOccurrencesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetVulnerabilitySummary
            extends ContainerAnalysisRequest<VulnerabilityOccurrencesSummary> {
                private static final String REST_PATH = "v1beta1/{+parent}/occurrences:vulnerabilitySummary";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;

                protected GetVulnerabilitySummary(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, VulnerabilityOccurrencesSummary.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetVulnerabilitySummary set$Xgafv(String string) {
                    return (GetVulnerabilitySummary)super.set$Xgafv(string);
                }

                public GetVulnerabilitySummary setAccessToken(String string) {
                    return (GetVulnerabilitySummary)super.setAccessToken(string);
                }

                public GetVulnerabilitySummary setAlt(String string) {
                    return (GetVulnerabilitySummary)super.setAlt(string);
                }

                public GetVulnerabilitySummary setCallback(String string) {
                    return (GetVulnerabilitySummary)super.setCallback(string);
                }

                public GetVulnerabilitySummary setFields(String string) {
                    return (GetVulnerabilitySummary)super.setFields(string);
                }

                public GetVulnerabilitySummary setKey(String string) {
                    return (GetVulnerabilitySummary)super.setKey(string);
                }

                public GetVulnerabilitySummary setOauthToken(String string) {
                    return (GetVulnerabilitySummary)super.setOauthToken(string);
                }

                public GetVulnerabilitySummary setPrettyPrint(Boolean bl) {
                    return (GetVulnerabilitySummary)super.setPrettyPrint(bl);
                }

                public GetVulnerabilitySummary setQuotaUser(String string) {
                    return (GetVulnerabilitySummary)super.setQuotaUser(string);
                }

                public GetVulnerabilitySummary setUploadType(String string) {
                    return (GetVulnerabilitySummary)super.setUploadType(string);
                }

                public GetVulnerabilitySummary setUploadProtocol(String string) {
                    return (GetVulnerabilitySummary)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetVulnerabilitySummary setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public GetVulnerabilitySummary setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                @Override
                public GetVulnerabilitySummary set(String string, Object object) {
                    return (GetVulnerabilitySummary)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetNotes
            extends ContainerAnalysisRequest<Note> {
                private static final String REST_PATH = "v1beta1/{+name}/notes";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetNotes(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, Note.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetNotes set$Xgafv(String string) {
                    return (GetNotes)super.set$Xgafv(string);
                }

                public GetNotes setAccessToken(String string) {
                    return (GetNotes)super.setAccessToken(string);
                }

                public GetNotes setAlt(String string) {
                    return (GetNotes)super.setAlt(string);
                }

                public GetNotes setCallback(String string) {
                    return (GetNotes)super.setCallback(string);
                }

                public GetNotes setFields(String string) {
                    return (GetNotes)super.setFields(string);
                }

                public GetNotes setKey(String string) {
                    return (GetNotes)super.setKey(string);
                }

                public GetNotes setOauthToken(String string) {
                    return (GetNotes)super.setOauthToken(string);
                }

                public GetNotes setPrettyPrint(Boolean bl) {
                    return (GetNotes)super.setPrettyPrint(bl);
                }

                public GetNotes setQuotaUser(String string) {
                    return (GetNotes)super.setQuotaUser(string);
                }

                public GetNotes setUploadType(String string) {
                    return (GetNotes)super.setUploadType(string);
                }

                public GetNotes setUploadProtocol(String string) {
                    return (GetNotes)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public GetNotes setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public GetNotes set(String string, Object object) {
                    return (GetNotes)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends ContainerAnalysisRequest<Policy> {
                private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ContainerAnalysisRequest<Occurrence> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, Occurrence.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ContainerAnalysisRequest<Empty> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String string) {
                    super(ContainerAnalysis.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/occurrences/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/occurrences/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ContainerAnalysisRequest<Occurrence> {
                private static final String REST_PATH = "v1beta1/{+parent}/occurrences";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, Occurrence occurrence) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)occurrence, Occurrence.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchCreate
            extends ContainerAnalysisRequest<BatchCreateOccurrencesResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/occurrences:batchCreate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchCreate(String string, BatchCreateOccurrencesRequest batchCreateOccurrencesRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)batchCreateOccurrencesRequest, BatchCreateOccurrencesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public BatchCreate set$Xgafv(String string) {
                    return (BatchCreate)super.set$Xgafv(string);
                }

                public BatchCreate setAccessToken(String string) {
                    return (BatchCreate)super.setAccessToken(string);
                }

                public BatchCreate setAlt(String string) {
                    return (BatchCreate)super.setAlt(string);
                }

                public BatchCreate setCallback(String string) {
                    return (BatchCreate)super.setCallback(string);
                }

                public BatchCreate setFields(String string) {
                    return (BatchCreate)super.setFields(string);
                }

                public BatchCreate setKey(String string) {
                    return (BatchCreate)super.setKey(string);
                }

                public BatchCreate setOauthToken(String string) {
                    return (BatchCreate)super.setOauthToken(string);
                }

                public BatchCreate setPrettyPrint(Boolean bl) {
                    return (BatchCreate)super.setPrettyPrint(bl);
                }

                public BatchCreate setQuotaUser(String string) {
                    return (BatchCreate)super.setQuotaUser(string);
                }

                public BatchCreate setUploadType(String string) {
                    return (BatchCreate)super.setUploadType(string);
                }

                public BatchCreate setUploadProtocol(String string) {
                    return (BatchCreate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchCreate setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public BatchCreate set(String string, Object object) {
                    return (BatchCreate)super.set(string, object);
                }
            }
        }

        public class Notes {
            public BatchCreate batchCreate(String string, BatchCreateNotesRequest batchCreateNotesRequest) throws IOException {
                BatchCreate batchCreate = new BatchCreate(string, batchCreateNotesRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)batchCreate);
                return batchCreate;
            }

            public Create create(String string, Note note) throws IOException {
                Create create = new Create(string, note);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Note note) throws IOException {
                Patch patch = new Patch(string, note);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            public Occurrences occurrences() {
                return new Occurrences();
            }

            public class Occurrences {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    ContainerAnalysis.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerAnalysisRequest<ListNoteOccurrencesResponse> {
                    private static final String REST_PATH = "v1beta1/{+name}/occurrences";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(ContainerAnalysis.this, "GET", REST_PATH, null, ListNoteOccurrencesResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends ContainerAnalysisRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends ContainerAnalysisRequest<Policy> {
                private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends ContainerAnalysisRequest<Note> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Note note) {
                    super(ContainerAnalysis.this, "PATCH", REST_PATH, (Object)note, Note.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ContainerAnalysisRequest<ListNotesResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/notes";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String filter;

                protected List(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, ListNotesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends ContainerAnalysisRequest<Policy> {
                private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ContainerAnalysisRequest<Note> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(ContainerAnalysis.this, "GET", REST_PATH, null, Note.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ContainerAnalysisRequest<Empty> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String string) {
                    super(ContainerAnalysis.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notes/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ContainerAnalysisRequest<Note> {
                private static final String REST_PATH = "v1beta1/{+parent}/notes";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String noteId;

                protected Create(String string, Note note) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)note, Note.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getNoteId() {
                    return this.noteId;
                }

                public Create setNoteId(String string) {
                    this.noteId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchCreate
            extends ContainerAnalysisRequest<BatchCreateNotesResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/notes:batchCreate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchCreate(String string, BatchCreateNotesRequest batchCreateNotesRequest) {
                    super(ContainerAnalysis.this, "POST", REST_PATH, (Object)batchCreateNotesRequest, BatchCreateNotesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public BatchCreate set$Xgafv(String string) {
                    return (BatchCreate)super.set$Xgafv(string);
                }

                public BatchCreate setAccessToken(String string) {
                    return (BatchCreate)super.setAccessToken(string);
                }

                public BatchCreate setAlt(String string) {
                    return (BatchCreate)super.setAlt(string);
                }

                public BatchCreate setCallback(String string) {
                    return (BatchCreate)super.setCallback(string);
                }

                public BatchCreate setFields(String string) {
                    return (BatchCreate)super.setFields(string);
                }

                public BatchCreate setKey(String string) {
                    return (BatchCreate)super.setKey(string);
                }

                public BatchCreate setOauthToken(String string) {
                    return (BatchCreate)super.setOauthToken(string);
                }

                public BatchCreate setPrettyPrint(Boolean bl) {
                    return (BatchCreate)super.setPrettyPrint(bl);
                }

                public BatchCreate setQuotaUser(String string) {
                    return (BatchCreate)super.setQuotaUser(string);
                }

                public BatchCreate setUploadType(String string) {
                    return (BatchCreate)super.setUploadType(string);
                }

                public BatchCreate setUploadProtocol(String string) {
                    return (BatchCreate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchCreate setParent(String string) {
                    if (!ContainerAnalysis.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public BatchCreate set(String string, Object object) {
                    return (BatchCreate)super.set(string, object);
                }
            }
        }
    }
}

