/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client.util;

import com.google.cloud.graphite.platforms.plugin.client.model.InstanceResourceData;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClientUtil {
    private static final Pattern INSTANCE_RESOURCE_DATA_PATTERN = Pattern.compile("https:\\/\\/www.googleapis.com\\/compute\\/v1\\/projects\\/([0-9a-zA-Z\\-]+)\\/zones\\/([a-z0-9\\-]+)\\/instances\\/([0-9a-zA-Z\\-]+)");

    public static <T> ImmutableList<T> processResourceList(List<T> items, Predicate<T> filter, Comparator<T> comparator) {
        if (items == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)items.stream().filter(filter).sorted(comparator).collect(Collectors.toList()));
    }

    public static <T> ImmutableList<T> processResourceList(List<T> items, Comparator<T> comparator) {
        return ClientUtil.processResourceList(items, n -> true, comparator);
    }

    public static String nameFromSelfLink(String selfLink) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)selfLink) ? 1 : 0) != 0);
        return selfLink.substring(selfLink.lastIndexOf("/") + 1);
    }

    public static String buildLabelsFilterString(Map<String, String> labels) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> l : labels.entrySet()) {
            sb.append("(labels.").append(l.getKey()).append(" eq ").append(l.getValue()).append(") ");
        }
        return sb.toString().trim();
    }

    public static String buildFilterString(Map<String, String> filters) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = filters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> f = it.next();
            sb.append(f.getKey()).append(String.format("=\"%s\"", f.getValue()));
            if (!it.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    public static Optional<InstanceResourceData> parseInstanceResourceData(String selfLink) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)selfLink) ? 1 : 0) != 0);
        Matcher matcher = INSTANCE_RESOURCE_DATA_PATTERN.matcher(selfLink);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(InstanceResourceData.builder().projectId(matcher.group(1)).zone(matcher.group(2)).name(matcher.group(3)).build());
    }
}

