/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.services.container.Container;
import com.google.api.services.container.model.Cluster;
import com.google.api.services.container.model.ListClustersResponse;
import java.io.IOException;
import java.util.List;

class ContainerWrapper {
    private static final String GET_RESOURCE_URL = "https://%s/v2/%s/%s/manifests/%s";
    private static final String MANIFEST_ACCEPT_TYPE = "application/vnd.oci.image.manifest.v1+json,application/vnd.docker.distribution.manifest.v2+json";
    private static final String DIGEST_HEADER = "docker-content-digest";
    private final Container container;

    ContainerWrapper(Container container) {
        this.container = container;
    }

    Cluster getCluster(String projectId, String location, String clusterName) throws IOException {
        return (Cluster)this.container.projects().locations().clusters().get(ContainerWrapper.toApiName(projectId, location, clusterName)).execute();
    }

    List<Cluster> listClusters(String projectId, String location) throws IOException {
        return ((ListClustersResponse)this.container.projects().locations().clusters().list(ContainerWrapper.toApiParent(projectId, location)).execute()).getClusters();
    }

    String getDigest(String domain, String projectId, String name, String tag) throws IOException {
        HttpRequest request = this.container.getRequestFactory().buildGetRequest(new GenericUrl(String.format(GET_RESOURCE_URL, domain, projectId, name, tag)));
        HttpHeaders headers = request.getHeaders();
        headers.setAccept(MANIFEST_ACCEPT_TYPE);
        return request.setHeaders(headers).execute().getHeaders().getFirstHeaderStringValue(DIGEST_HEADER);
    }

    private static String toApiName(String projectId, String location, String clusterName) {
        return String.format("projects/%s/locations/%s/clusters/%s", projectId, location, clusterName);
    }

    private static String toApiParent(String projectId, String location) {
        return String.format("projects/%s/locations/%s", projectId, location);
    }
}

