/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.container.model.Cluster;
import com.google.cloud.graphite.platforms.plugin.client.ContainerWrapper;
import com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Comparator;

public class ContainerClient {
    private static final String LOCATION_WILDCARD = "-";
    private final ContainerWrapper container;

    public ContainerClient(ContainerWrapper container) {
        this.container = (ContainerWrapper)Preconditions.checkNotNull((Object)container);
    }

    public Cluster getCluster(String projectId, String location, String cluster) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cluster) ? 1 : 0) != 0);
        return this.container.getCluster(projectId, location, cluster);
    }

    public ImmutableList<Cluster> listAllClusters(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.container.listClusters(projectId, LOCATION_WILDCARD), Comparator.comparing(Cluster::getName));
    }

    public String getDigest(String resourceUri, String tag) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceUri) ? 1 : 0) != 0);
        Preconditions.checkArgument((resourceUri.split("/").length >= 3 ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tag) ? 1 : 0) != 0);
        String[] tokens = resourceUri.split("/", 3);
        return this.container.getDigest(tokens[0], tokens[1], tokens[2], tag);
    }
}

