/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.containeranalysis.v1beta1.ContainerAnalysis;
import com.google.api.services.containeranalysis.v1beta1.model.Attestation;
import com.google.api.services.containeranalysis.v1beta1.model.Details;
import com.google.api.services.containeranalysis.v1beta1.model.GenericSignedAttestation;
import com.google.api.services.containeranalysis.v1beta1.model.ListOccurrencesResponse;
import com.google.api.services.containeranalysis.v1beta1.model.Occurrence;
import com.google.api.services.containeranalysis.v1beta1.model.Resource;
import com.google.api.services.containeranalysis.v1beta1.model.Signature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public class ContainerAnalysisWrapper {
    private ContainerAnalysis containerAnalysis;

    ContainerAnalysisWrapper(ContainerAnalysis containerAnalysis) {
        this.containerAnalysis = containerAnalysis;
    }

    List<Occurrence> listOccurrences(String projectId, String filter) throws IOException {
        return ((ListOccurrencesResponse)this.containerAnalysis.projects().occurrences().list(ContainerAnalysisWrapper.toOccurrenceParent(projectId)).setFilter(filter).setPageSize(Integer.valueOf(1000)).execute()).getOccurrences();
    }

    Occurrence getOccurrence(String projectId, String occurrenceId) throws IOException {
        return (Occurrence)this.containerAnalysis.projects().occurrences().get(ContainerAnalysisWrapper.toOccurrenceName(projectId, occurrenceId)).execute();
    }

    Occurrence createAttestation(String projectId, String resourceUri, String noteProjectId, String noteId, String signature, String publicKeyId, String payload) throws IOException {
        return (Occurrence)this.containerAnalysis.projects().occurrences().create(ContainerAnalysisWrapper.toOccurrenceParent(projectId), ContainerAnalysisWrapper.toAttestationOccurrence(resourceUri, noteProjectId, noteId, signature, publicKeyId, payload)).execute();
    }

    private static String toOccurrenceParent(String projectId) {
        return String.format("projects/%s", projectId);
    }

    @VisibleForTesting
    static String toOccurrenceName(String projectId, String occurrenceId) {
        return String.format("projects/%s/occurrences/%s", projectId, occurrenceId);
    }

    private static String toNoteName(String projectId, String note) {
        return String.format("projects/%s/notes/%s", projectId, note);
    }

    private static Signature toSignature(String signature, String publicKeyId) {
        return new Signature().setSignature(signature).setPublicKeyId(publicKeyId);
    }

    private static Attestation toAttestation(String signature, String publicKeyId, String payload) {
        return new Attestation().setGenericSignedAttestation(new GenericSignedAttestation().setSignatures((List)ImmutableList.of((Object)ContainerAnalysisWrapper.toSignature(signature, publicKeyId))).setSerializedPayload(payload));
    }

    @VisibleForTesting
    static Occurrence toAttestationOccurrence(String resourceUri, String noteProjectId, String noteId, String signature, String publicKeyId, String payload) {
        return new Occurrence().setResource(new Resource().setUri(resourceUri)).setNoteName(ContainerAnalysisWrapper.toNoteName(noteProjectId, noteId)).setKind("ATTESTATION").setAttestation(new Details().setAttestation(ContainerAnalysisWrapper.toAttestation(signature, publicKeyId, payload)));
    }
}

